/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.comm.http.HttpHeaderTypes;
import de.esoco.lib.comm.http.HttpRequestMethod;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.Conversions;
import de.esoco.lib.io.StreamUtil;
import de.esoco.lib.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;

public class HttpRequest
extends RelatedObject {
    private final Reader requestReader;
    private final HttpRequestMethod requestMethod;
    private final String requestPath;
    private final Map<String, List<String>> requestHeaders;
    private int maxLineLength;

    public HttpRequest(InputStream input, int maxLineLength) throws IOException, HttpStatusException {
        this.maxLineLength = maxLineLength;
        this.requestReader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        String requestLine = this.readLine(this.requestReader);
        if (requestLine == null) {
            HttpStatusCode.badRequest("Unterminated request");
        } else if (requestLine.isEmpty()) {
            HttpStatusCode.badRequest("Empty request line");
        }
        HttpRequestMethod method = HttpRequestMethod.GET;
        String[] requestParts = requestLine.split(" ");
        if (requestParts.length != 3 || !requestParts[2].startsWith("HTTP/")) {
            HttpStatusCode.badRequest("Malformed request line: " + requestLine);
        }
        try {
            method = HttpRequestMethod.valueOf(requestParts[0]);
        }
        catch (Exception e) {
            HttpStatusCode.badRequest("Unknown request method: " + requestParts[0]);
        }
        this.requestMethod = method;
        this.requestPath = requestParts[1];
        this.requestHeaders = this.readHeaders(this.requestReader);
        Log.debugf("Request: %s %s", requestLine, this.requestHeaders);
    }

    public HttpRequest(HttpRequestMethod requestMethod, String requestPath, Map<String, List<String>> requestHeaders, Reader requestBodyReader) {
        this.requestMethod = requestMethod;
        this.requestPath = requestPath;
        this.requestHeaders = requestHeaders;
        this.requestReader = requestBodyReader;
    }

    public final String getBody() throws IOException {
        Integer length = (Integer)this.get(HttpHeaderTypes.CONTENT_LENGTH);
        if (length == null) {
            throw new HttpStatusException(HttpStatusCode.LENGTH_REQUIRED, "Content-Length header missing", new Pair[0]);
        }
        return StreamUtil.readAll(this.requestReader, 8192, (int)length);
    }

    public final Reader getBodyReader() {
        return this.requestReader;
    }

    public final List<String> getHeaderField(String name) {
        return this.requestHeaders.get(name);
    }

    public final List<String> getHeaderField(HttpHeaderTypes.HttpHeaderField field) {
        return this.getHeaderField(field.getFieldName());
    }

    public final HttpRequestMethod getMethod() {
        return this.requestMethod;
    }

    public final String getPath() {
        return this.requestPath;
    }

    public String toString() {
        return String.format("%s[%s %s]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.requestMethod, this.requestPath});
    }

    protected void parseRequestHeader(String headerName, String headerValue) throws HttpStatusException {
        RelationType<?> headerType = HttpHeaderTypes.get(headerName);
        if (headerType != null) {
            try {
                Object value = Conversions.parseValue((String)headerValue, (Class)headerType.getTargetType());
                this.set(headerType, value);
            }
            catch (Exception e) {
                HttpStatusCode.badRequest(String.format("Invalid value for header '%s': %s", headerName, headerValue));
            }
        }
    }

    protected Map<String, List<String>> readHeaders(Reader inputReader) throws IOException, HttpStatusException {
        String header;
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        do {
            if ((header = this.readLine(inputReader)) == null) {
                HttpStatusCode.badRequest("Request must be terminated with CRLF on empty line");
                continue;
            }
            if (header.isEmpty()) continue;
            int colon = header.indexOf(58);
            if (colon < 1) {
                HttpStatusCode.badRequest("Malformed header: " + header);
            }
            String headerName = header.substring(0, colon).trim();
            String headerValue = header.substring(colon + 1).trim();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(headerName);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
            }
            headerValues.add(headerValue);
            headers.put(headerName, headerValues);
            this.parseRequestHeader(headerName, headerValue);
        } while (!header.isEmpty());
        return headers;
    }

    protected String readLine(Reader reader) throws IOException {
        StringWriter result = new StringWriter();
        String line = null;
        if (StreamUtil.readUntil(reader, result, "\r\n", this.maxLineLength, false)) {
            line = result.toString();
            line = line.substring(0, line.length() - 2);
        } else {
            if (result.getBuffer().length() == 0) {
                throw new HttpStatusException.EmptyRequestException();
            }
            HttpStatusCode.badRequest("Request line not terminated with CRLF");
        }
        return line;
    }
}

