/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Server;
import de.esoco.lib.comm.http.HttpHeaderTypes;
import de.esoco.lib.comm.http.HttpRequest;
import de.esoco.lib.comm.http.HttpResponse;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.io.EchoInputStream;
import de.esoco.lib.logging.Log;
import de.esoco.lib.security.AuthenticationService;
import de.esoco.lib.security.SecurityRelationTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.type.StandardTypes;

public class HttpRequestHandler
extends RelatedObject
implements Server.RequestHandler {
    private static final Set<String> SUPPORTED_AUTH_METHODS = CollectionUtil.setOf((Object[])new String[]{"Basic", "BCrypt"});
    private static final ThreadLocal<HttpRequest> threadLocalRequest = new ThreadLocal();
    private final Relatable context;
    private HttpRequestMethodHandler requestMethodHandler = null;

    public HttpRequestHandler(Relatable context, HttpRequestMethodHandler handler) {
        this.context = context;
        this.requestMethodHandler = handler;
    }

    protected HttpRequestHandler(Relatable context) {
        this.context = context;
        if (this instanceof HttpRequestMethodHandler) {
            this.requestMethodHandler = (HttpRequestMethodHandler)((Object)this);
        }
    }

    public static final HttpRequest getThreadLocalRequest() {
        return threadLocalRequest.get();
    }

    public final Relatable getContext() {
        return this.context;
    }

    public final HttpRequestMethodHandler getRequestMethodHandler() {
        return this.requestMethodHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handleRequest(InputStream requestStream, OutputStream responseStream) throws IOException {
        String result;
        ByteArrayOutputStream requestCopy = new ByteArrayOutputStream(2048);
        try {
            requestStream = new EchoInputStream(requestStream, requestCopy);
            HttpRequest httpRequest = this.readRequest(requestStream);
            httpRequest.set(StandardTypes.IP_ADDRESS, (InetAddress)this.get(StandardTypes.IP_ADDRESS));
            threadLocalRequest.set(httpRequest);
            this.checkAuthentication(httpRequest);
            this.sendResponse(this.createResponse(httpRequest), responseStream);
        }
        catch (Exception e) {
            HttpStatusCode status = HttpStatusCode.INTERNAL_SERVER_ERROR;
            boolean emptyRequest = e instanceof HttpStatusException.EmptyRequestException;
            String message = "";
            Map<HttpHeaderTypes.HttpHeaderField, String> responseHeaders = null;
            this.set(StandardTypes.EXCEPTION, e);
            if (e instanceof HttpStatusException) {
                HttpStatusException statusException = (HttpStatusException)e;
                message = statusException.getMessage();
                status = statusException.getStatusCode();
                responseHeaders = statusException.getResponseHeaders();
                if (!emptyRequest) {
                    Log.infof("HTTP status exception (%s): %s", new Object[]{status, message});
                }
            } else {
                Log.error("HTTP Request failed", e);
            }
            if (!emptyRequest) {
                HttpResponse errorResponse = new HttpResponse(status, message);
                if (responseHeaders != null) {
                    for (Map.Entry<HttpHeaderTypes.HttpHeaderField, String> header : responseHeaders.entrySet()) {
                        errorResponse.setHeader(header.getKey(), header.getValue());
                    }
                }
                try {
                    errorResponse.write(responseStream);
                }
                catch (Exception response) {
                    Log.info("Response output failed", response);
                }
            }
        }
        finally {
            result = requestCopy.toString(StandardCharsets.UTF_8.name());
        }
        responseStream.flush();
        return result;
    }

    protected void checkAuthentication(HttpRequest request) throws HttpStatusException {
        AuthenticationService authService = (AuthenticationService)this.context.get(SecurityRelationTypes.AUTHENTICATION_SERVICE);
        if (authService != null) {
            String[] credential;
            String method;
            boolean authenticated = false;
            String auth = (String)request.get(HttpHeaderTypes.AUTHORIZATION);
            if (auth == null) {
                throw new HttpStatusException(HttpStatusCode.UNAUTHORIZED, "Authentication required", this.getAuthErrorHeader());
            }
            String[] authHeader = auth.trim().split(" ");
            if (authHeader.length == 2 && SUPPORTED_AUTH_METHODS.contains(method = authHeader[0]) && (credential = new String(Base64.getDecoder().decode(authHeader[1]), StandardCharsets.UTF_8).split(":")).length == 2) {
                RelatedObject authData = new RelatedObject();
                authData.set(SecurityRelationTypes.AUTHENTICATION_METHOD, (Object)method);
                authData.set(SecurityRelationTypes.LOGIN_NAME, (Object)credential[0]);
                authData.set(SecurityRelationTypes.PASSWORD, (Object)credential[1].toCharArray());
                authenticated = authService.authenticate((Relatable)authData);
            }
            if (!authenticated) {
                throw new HttpStatusException(HttpStatusCode.UNAUTHORIZED, "Authentication invalid", this.getAuthErrorHeader());
            }
        }
    }

    protected HttpResponse createResponse(HttpRequest request) throws IOException {
        return this.requestMethodHandler.handleMethod(request);
    }

    protected Pair<HttpHeaderTypes.HttpHeaderField, String> getAuthErrorHeader() {
        return new Pair((Object)HttpHeaderTypes.HttpHeaderField.WWW_AUTHENTICATE, (Object)String.format("Basic realm=\"%s\"", this.getContext().get(StandardTypes.NAME)));
    }

    protected HttpRequest readRequest(InputStream input) throws IOException, HttpStatusException {
        return new HttpRequest(input, (Integer)this.context.get(CommunicationRelationTypes.HTTP_MAX_HEADER_LINE_SIZE));
    }

    protected void sendResponse(HttpResponse response, OutputStream output) throws IOException {
        Map defaultResponseHeaders = (Map)this.context.get(CommunicationRelationTypes.HTTP_RESPONSE_HEADERS);
        Map responseHeaders = (Map)response.get(CommunicationRelationTypes.HTTP_RESPONSE_HEADERS);
        for (Map.Entry defaultHeader : defaultResponseHeaders.entrySet()) {
            String headerName = (String)defaultHeader.getKey();
            if (responseHeaders.containsKey(headerName)) continue;
            responseHeaders.put(headerName, (List)defaultHeader.getValue());
        }
        response.write(output);
    }

    protected final void setRequestMethodHandler(HttpRequestMethodHandler handler) {
        this.requestMethodHandler = handler;
    }

    @FunctionalInterface
    public static interface HttpRequestMethodHandler {
        default public HttpResponse doDelete(HttpRequest request) throws HttpStatusException {
            throw new HttpStatusException(HttpStatusCode.NOT_IMPLEMENTED, "DELETE not supported", new Pair[0]);
        }

        public HttpResponse doGet(HttpRequest var1) throws HttpStatusException;

        default public HttpResponse doPost(HttpRequest request) throws HttpStatusException {
            throw new HttpStatusException(HttpStatusCode.NOT_IMPLEMENTED, "POST not supported", new Pair[0]);
        }

        default public HttpResponse doPut(HttpRequest request) throws HttpStatusException {
            throw new HttpStatusException(HttpStatusCode.NOT_IMPLEMENTED, "PUT not supported", new Pair[0]);
        }

        default public HttpResponse handleMethod(HttpRequest request) throws IOException {
            HttpResponse response = null;
            switch (request.getMethod()) {
                case GET: {
                    response = this.doGet(request);
                    break;
                }
                case DELETE: {
                    response = this.doDelete(request);
                    break;
                }
                case POST: {
                    response = this.doPost(request);
                    break;
                }
                case PUT: {
                    response = this.doPut(request);
                    break;
                }
                default: {
                    HttpStatusCode.badRequest("Unsupported request method: " + (Object)((Object)request.getMethod()));
                }
            }
            return response;
        }
    }
}

