/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import java.net.HttpURLConnection;
import java.net.ProtocolException;

public enum HttpRequestMethod {
    GET(false),
    HEAD(false),
    OPTIONS(true),
    TRACE(false),
    POST(true),
    PUT(true),
    DELETE(false),
    CONNECT(true);

    private final boolean doesOutput;

    private HttpRequestMethod(boolean doesOutput) {
        this.doesOutput = doesOutput;
    }

    public void applyTo(HttpURLConnection connection) {
        try {
            connection.setRequestMethod(this.name());
            connection.setDoOutput(this.doesOutput);
        }
        catch (ProtocolException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean doesOutput() {
        return this.doesOutput;
    }
}

