/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.http.HttpHeaderTypes;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.io.StreamUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;

public class HttpResponse
extends RelatedObject {
    private final Reader responseBodyReader;

    public HttpResponse(String responseData) {
        this(HttpStatusCode.OK, responseData);
    }

    public HttpResponse(Reader responseData, int responseLength) {
        this(HttpStatusCode.OK, responseData, responseLength);
    }

    public HttpResponse(HttpStatusCode status, String responseData) {
        this(status, new StringReader(responseData), responseData.length());
    }

    public HttpResponse(HttpStatusCode status, Reader responseData, int responseLength) {
        this.responseBodyReader = responseData;
        this.init(HttpHeaderTypes.HTTP_HEADER_TYPES);
        this.set(CommunicationRelationTypes.HTTP_STATUS_CODE, (Object)status);
        this.set(HttpHeaderTypes.CONTENT_LENGTH, responseLength);
    }

    public List<String> setHeader(HttpHeaderTypes.HttpHeaderField field, String value) {
        return ((Map)this.get(CommunicationRelationTypes.HTTP_RESPONSE_HEADERS)).put(field.getFieldName(), Collections.singletonList(value));
    }

    public <T> HttpResponse with(RelationType<T> type, T value) {
        this.set(type, value);
        return this;
    }

    public void write(OutputStream output) throws IOException {
        BufferedWriter responseHeaderWriter = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.US_ASCII));
        OutputStreamWriter responseBodyWriter = new OutputStreamWriter(output, (Charset)this.get(CommunicationRelationTypes.RESPONSE_ENCODING));
        Collection headerTypes = (Collection)this.get(HttpHeaderTypes.HTTP_HEADER_TYPES);
        for (RelationType header : headerTypes) {
            this.setHeader((HttpHeaderTypes.HttpHeaderField)((Object)header.get(HttpHeaderTypes.HTTP_HEADER_FIELD)), this.get(header).toString());
        }
        this.writeResponseHeader((HttpStatusCode)((Object)this.get(CommunicationRelationTypes.HTTP_STATUS_CODE)), (Map)this.get(CommunicationRelationTypes.HTTP_RESPONSE_HEADERS), responseHeaderWriter);
        StreamUtil.send(this.responseBodyReader, responseBodyWriter);
        ((Writer)responseHeaderWriter).flush();
        ((Writer)responseBodyWriter).flush();
        output.flush();
    }

    protected void writeResponseHeader(HttpStatusCode status, Map<String, List<String>> responseHeaders, Writer out) throws IOException {
        out.write(status.toResponseString());
        for (Map.Entry<String, List<String>> responseHeader : responseHeaders.entrySet()) {
            out.write(responseHeader.getKey());
            out.write(": ");
            out.write(responseHeader.getValue().get(0));
            out.write("\r\n");
        }
        out.write("\r\n");
        out.flush();
    }
}

