/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.datatype.Pair;

public enum HttpStatusCode {
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    PROCESSING(102, "Processing"),
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MULTI_STATUS(207, "Multi-Status"),
    ALREADY_REPORTED(208, "Already Reported"),
    IM_USED(226, "IM Used"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIME_OUT(408, "Request Time-out"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LARGE(414, "Request-URI Too Large"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    POLICY_NOT_FULFILLED(420, "Policy Not Fulfilled"),
    MISDIRECTED_REQUEST(421, "Misdirected Request"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    UNORDERED_COLLECTION(425, "Unordered Collection"),
    UPGRADE_REQUIRED(426, "Upgrade Required"),
    PRECONDITION_REQUIRED(428, "Precondition Required"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    UNAVAILABLE_FOR_LEGAL_REASONS(451, "Unavailable For Legal Reasons"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIME_OUT(504, "Gateway Time-out"),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported"),
    VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    LOOP_DETECTED(508, "Loop Detected"),
    BANDWIDTH_LIMIT_EXCEEDED(509, "Bandwidth Limit Exceeded"),
    NOT_EXTENDED(510, "Not Extended"),
    NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required");

    private final int statusCode;
    private final String reasonPhrase;

    private HttpStatusCode(int code, String reason) {
        this.statusCode = code;
        this.reasonPhrase = reason;
    }

    public static void badRequest(String message) throws HttpStatusException {
        throw new HttpStatusException(BAD_REQUEST, message, new Pair[0]);
    }

    public static HttpStatusCode valueOf(int code) {
        for (HttpStatusCode statusCode : HttpStatusCode.values()) {
            if (statusCode.statusCode != code) continue;
            return statusCode;
        }
        throw new IllegalArgumentException("No " + HttpStatusCode.class.getSimpleName() + " instance with code " + code);
    }

    public final int getCode() {
        return this.statusCode;
    }

    public final String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public final String getStatusLine() {
        String statusLine = "HTTP/1.1 " + this.statusCode + ' ' + this.reasonPhrase + "\r\n";
        return statusLine;
    }

    public final boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode <= 499;
    }

    public final boolean isError() {
        return this.statusCode >= 400;
    }

    public final boolean isInformational() {
        return this.statusCode >= 100 && this.statusCode <= 199;
    }

    public final boolean isRedirection() {
        return this.statusCode >= 300 && this.statusCode <= 399;
    }

    public final boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode <= 599;
    }

    public final boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode <= 299;
    }

    public String toResponseString() {
        return String.format("HTTP/1.1 %s\r\n", new Object[]{this});
    }

    public String toString() {
        return this.statusCode + " " + this.reasonPhrase;
    }
}

