/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.comm.http.HttpHeaderTypes;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.datatype.Pair;
import java.util.Collections;
import java.util.Map;

public class HttpStatusException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final HttpStatusCode statusCode;
    private Map<HttpHeaderTypes.HttpHeaderField, String> responseHeaders = Collections.emptyMap();

    public HttpStatusException(HttpStatusCode statusCode, Exception cause) {
        super(cause);
        this.statusCode = statusCode;
    }

    @SafeVarargs
    public HttpStatusException(HttpStatusCode statusCode, String message, Pair<HttpHeaderTypes.HttpHeaderField, String> ... responseHeaders) {
        super(message);
        this.statusCode = statusCode;
        this.responseHeaders = CollectionUtil.fixedOrderedMapOf(responseHeaders);
    }

    public HttpStatusException(HttpStatusCode statusCode, String message, Exception cause) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public final Map<HttpHeaderTypes.HttpHeaderField, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public final HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public static class EmptyRequestException
    extends HttpStatusException {
        private static final long serialVersionUID = 1L;

        public EmptyRequestException() {
            super(HttpStatusCode.BAD_REQUEST, "Request empty", new Pair[0]);
        }
    }
}

