/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.http;

import de.esoco.lib.comm.http.HttpRequest;
import de.esoco.lib.comm.http.HttpRequestHandler;
import de.esoco.lib.comm.http.HttpResponse;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.logging.Log;
import org.obrel.space.ObjectSpace;
import org.obrel.space.SynchronizedObjectSpace;

public class ObjectSpaceHttpMethodHandler
implements HttpRequestHandler.HttpRequestMethodHandler {
    private final ObjectSpace<? super String> objectSpace;
    private final String defaultPath;

    public ObjectSpaceHttpMethodHandler(ObjectSpace<? super String> objectSpace, String defaultPath) {
        this.objectSpace = new SynchronizedObjectSpace(objectSpace);
        this.defaultPath = defaultPath;
    }

    @Override
    public HttpResponse doGet(HttpRequest request) throws HttpStatusException {
        String path = request.getPath();
        if (path.isEmpty() || path.equals("/")) {
            path = this.defaultPath;
        }
        try {
            Object data = this.objectSpace.get(path);
            if (data == null) {
                throw new IllegalArgumentException();
            }
            return new HttpResponse(data.toString());
        }
        catch (RuntimeException e) {
            throw new HttpStatusException(HttpStatusCode.NOT_FOUND, "No data at " + path, new Pair[0]);
        }
    }

    @Override
    public HttpResponse doPost(HttpRequest request) throws HttpStatusException {
        return this.update(request);
    }

    @Override
    public HttpResponse doPut(HttpRequest request) throws HttpStatusException {
        return this.update(request);
    }

    private HttpResponse update(HttpRequest request) throws HttpStatusException {
        String path = request.getPath();
        String data = null;
        try {
            data = request.getBody();
            this.objectSpace.put(path, (Object)data);
            return new HttpResponse("");
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            Log.errorf(e, "ObjectSpace update failed: %s - %s", path, data);
            if (data == null) {
                throw new HttpStatusException(HttpStatusCode.BAD_REQUEST, "Could not access request data: " + e.getMessage(), new Pair[0]);
            }
            throw new HttpStatusException(HttpStatusCode.NOT_ACCEPTABLE, "Invalid data '" + data + "': " + e.getMessage(), new Pair[0]);
        }
    }
}

