/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.smtp;

import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.comm.EndpointFunction;
import de.esoco.lib.comm.SmtpEndpoint;
import de.esoco.lib.comm.smtp.Email;
import de.esoco.lib.logging.LogAspect;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.logging.LogRecord;
import java.util.Collection;
import java.util.Date;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;

public class MailLogging
extends LogAspect<Email> {
    private final Endpoint mailServer;
    private final Email emailTemplate = Email.email();

    public MailLogging(String smtpEndpointUrl) {
        this.set(MIN_LOG_LEVEL, (Object)LogLevel.ERROR);
        this.mailServer = Endpoint.at(smtpEndpointUrl);
    }

    public MailLogging from(String sender) {
        this.emailTemplate.from(sender);
        return this;
    }

    public MailLogging loginAs(String userName, String password) {
        this.mailServer.set(CommunicationRelationTypes.USER_NAME, userName);
        this.mailServer.set(CommunicationRelationTypes.PASSWORD, password);
        return this;
    }

    public MailLogging to(String receiver) {
        this.emailTemplate.to(receiver);
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", super.toString(), this.mailServer.get(CommunicationRelationTypes.ENDPOINT_ADDRESS));
    }

    @Override
    protected Email createLogObject(LogRecord logRecord) {
        String message = logRecord.format((LogLevel)((Object)this.get(MIN_STACK_LOG_LEVEL)));
        Email email = new Email();
        ObjectRelations.copyRelations((Relatable)this.emailTemplate, (Relatable)email, (boolean)false);
        email.subject(String.format("[%1$s]%2$tF %2$tT: %3$s", new Object[]{logRecord.getLevel(), new Date(logRecord.getTime()), logRecord.getMessage()}));
        email.message(message);
        return email;
    }

    @Override
    protected String getLogInitMessage() {
        return "Starting logging to mail server at " + (String)this.mailServer.get(CommunicationRelationTypes.ENDPOINT_ADDRESS);
    }

    @Override
    protected void processLogObjects(Collection<Email> logEmails) throws Exception {
        EndpointFunction sendMail = SmtpEndpoint.sendMail().on(this.mailServer);
        for (Email email : logEmails) {
            sendMail.send(email);
        }
    }
}

