/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.comm.smtp;

import de.esoco.lib.comm.CommunicationException;
import de.esoco.lib.comm.smtp.Email;
import de.esoco.lib.comm.smtp.SmtpStatusCode;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;

public class SmtpProtocolHandler {
    private final String client;
    private final DataOutputStream output;
    private final BufferedReader input;

    public SmtpProtocolHandler(String client, OutputStream outputStream, InputStream inputStream) {
        this.client = client;
        this.output = new DataOutputStream(outputStream);
        this.input = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void connect(String user, String password) {
        this.checkResponse(SmtpStatusCode.READY);
        if (user != null) {
            this.send("EHLO " + this.client, new Object[0]).skipResponses(SmtpStatusCode.OK);
            String authPlain = String.format("%1$s\u0000%1$s\u0000%2$s", user, password);
            authPlain = "AUTH PLAIN " + Base64.getEncoder().encodeToString(authPlain.getBytes());
            this.send(authPlain, new Object[0]).checkResponse(SmtpStatusCode.OK, SmtpStatusCode.AUTH_SUCCESS);
        } else {
            this.send("HELO " + this.client, new Object[0]).checkOk();
        }
    }

    public void disconnect() {
        this.send("QUIT", new Object[0]).skipResponses(SmtpStatusCode.OK, SmtpStatusCode.CLOSING);
    }

    public void send(Email email) {
        String senderName = (String)email.get(Email.SENDER_NAME);
        String senderAddress = (String)email.get(Email.SENDER_ADDRESS);
        String recipientName = (String)email.get(Email.RECIPIENT_NAME);
        String recipientAddress = (String)email.get(Email.RECIPIENT_ADDRESS);
        this.send("MAIL FROM:<%s>", senderAddress).checkOk();
        this.send("RCPT TO:<%s>", recipientAddress).checkOk();
        this.send("DATA", new Object[0]).checkResponse(SmtpStatusCode.OK, SmtpStatusCode.START_MAIL);
        this.send("Date: %s", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
        this.sendAddress("From", senderName, senderAddress);
        this.sendAddress("To", recipientName, recipientAddress);
        this.send("Subject: %s", email.get(Email.SUBJECT));
        this.send("Mime-Version: 1.0", new Object[0]);
        this.send("Content-Type: text/plain; charset=\"utf-8\"", new Object[0]);
        this.send("Content-Transfer-Encoding: quoted-printable", new Object[0]);
        this.send("", new Object[0]);
        this.send((String)email.get(Email.MESSAGE), new Object[0]);
        this.send(".", new Object[0]).checkOk();
    }

    String checkOk() {
        return this.checkResponse(SmtpStatusCode.OK);
    }

    String checkResponse(SmtpStatusCode ... expectedStatusCodes) {
        try {
            String response = this.input.readLine();
            for (SmtpStatusCode status : expectedStatusCodes) {
                if (!response.startsWith(status.getCode())) continue;
                return response;
            }
            throw new CommunicationException("Expected one of [%s] but response was %s", Arrays.asList(expectedStatusCodes), response);
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }

    SmtpProtocolHandler send(String dataFormat, Object ... formatArgs) {
        try {
            this.output.writeBytes(String.format(dataFormat + "\n", formatArgs));
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
        return this;
    }

    void sendAddress(String field, String name, String address) {
        if (name != null) {
            this.send("%s: %s <%s>", field, name, address);
        } else {
            this.send("%s: %s", field, address);
        }
    }

    void skipResponses(SmtpStatusCode ... statusCodes) {
        try {
            while (this.input.ready()) {
                this.checkResponse(statusCodes);
            }
        }
        catch (IOException e) {
            throw new CommunicationException(e);
        }
    }
}

