/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.concurrent;

import de.esoco.lib.expression.ThrowingSupplier;

public class ResultRunner<T>
implements Runnable {
    private final ThrowingSupplier<T> createResult;
    private T result = null;
    private Throwable exception = null;
    private boolean finished = false;

    public ResultRunner(ThrowingSupplier<T> createResult) {
        this.createResult = createResult;
    }

    public final Throwable getException() {
        return this.exception;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public final T result() {
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
        return this.result;
    }

    @Override
    public final void run() {
        try {
            this.result = this.createResult.tryGet();
        }
        catch (Throwable t) {
            this.exception = t;
        }
        finally {
            this.finish();
        }
    }

    private final synchronized void finish() {
        this.finished = true;
    }
}

