/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.concurrent;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadMap<T>
extends AbstractMap<Thread, T> {
    private final Map<Thread, T> threadMap;

    public ThreadMap() {
        this.threadMap = new ConcurrentHashMap<Thread, T>();
    }

    public ThreadMap(Map<? extends Thread, ? extends T> map) {
        this.threadMap = new ConcurrentHashMap<Thread, T>(map);
    }

    @Override
    public Set<Map.Entry<Thread, T>> entrySet() {
        return this.threadMap.entrySet();
    }

    public T get() {
        this.cleanup();
        return (T)this.get(Thread.currentThread());
    }

    public T put(T value) {
        return this.put(Thread.currentThread(), value);
    }

    @Override
    public T put(Thread thread, T value) {
        this.cleanup();
        return this.threadMap.put(thread, value);
    }

    public T remove() {
        return (T)this.remove(Thread.currentThread());
    }

    private void cleanup() {
        Iterator<Thread> iterator = this.threadMap.keySet().iterator();
        while (iterator.hasNext()) {
            Thread thread = iterator.next();
            if (thread.isAlive()) continue;
            iterator.remove();
        }
    }
}

