/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.datatype;

import de.esoco.lib.datatype.Period;
import de.esoco.lib.expression.function.CalendarFunctions;
import java.io.Serializable;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;

public class DateRange
implements Comparable<DateRange>,
Serializable {
    static final long serialVersionUID = 3730180974383009738L;
    private final long start;
    private final long end;
    private volatile int hashCode = 0;

    public DateRange(Date start, Date end) {
        this(start.getTime(), end != null ? end.getTime() : Long.MAX_VALUE);
    }

    public DateRange(Calendar start, Calendar end) {
        this(start.getTimeInMillis(), end != null ? end.getTimeInMillis() : Long.MAX_VALUE);
    }

    public DateRange(Instant start, Instant end) {
        this(start.toEpochMilli(), end != null ? end.toEpochMilli() : Long.MAX_VALUE);
    }

    public DateRange(long startMillis, long endMillis) {
        if (startMillis > endMillis) {
            throw new IllegalArgumentException(String.format("Start > End: %s > %s", new Date(startMillis), new Date(endMillis)));
        }
        this.start = startMillis;
        this.end = endMillis;
    }

    public static DateRange calculateFor(StandardDateRange standardRange) {
        return DateRange.calculateFor(new Date(), standardRange);
    }

    public static DateRange calculateFor(Date date, StandardDateRange standardRange) {
        if (standardRange.fieldAddition != 0) {
            Calendar rangeDate = Calendar.getInstance();
            rangeDate.setTime(date);
            rangeDate.add(standardRange.period.getUnit().getCalendarField(), standardRange.fieldAddition);
            date = rangeDate.getTime();
        }
        return DateRange.calculateFor(date, standardRange.period);
    }

    public static DateRange calculateFor(Date date, Period period) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int field = period.getUnit().getCalendarField();
        int rangeSize = period.getCount();
        start.setTime(date);
        int rangeStart = start.get(field);
        if (rangeSize > 1) {
            boolean zeroBased = CalendarFunctions.isZeroBased((int)field);
            if (!zeroBased) {
                --rangeStart;
            }
            rangeStart = rangeStart / rangeSize * rangeSize;
            if (!zeroBased) {
                ++rangeStart;
            }
        }
        start.set(field, rangeStart);
        if (field == 3) {
            CalendarFunctions.resetBelow((int)5, (Calendar)start, (boolean)false);
            start.set(7, 2);
        } else {
            CalendarFunctions.resetBelow((int)field, (Calendar)start, (boolean)false);
        }
        end.setTime(start.getTime());
        end.add(field, rangeSize);
        return new DateRange(start, end);
    }

    @Override
    public int compareTo(DateRange other) {
        if (this.end != other.end) {
            return this.end < other.end ? -1 : 1;
        }
        if (this.start != other.start) {
            return this.start < other.start ? -1 : 1;
        }
        return 0;
    }

    public boolean contains(Date date) {
        long t = date.getTime();
        return this.start <= t && t < this.end;
    }

    public boolean contains(DateRange range) {
        return range.start >= this.start && range.end <= this.end;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DateRange) {
            return this.compareTo((DateRange)obj) == 0;
        }
        return false;
    }

    public Date getEnd() {
        return new Date(this.end);
    }

    public Date getStart() {
        return new Date(this.start);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)((37L + this.start) * 37L + this.end);
        }
        return this.hashCode;
    }

    public boolean overlaps(DateRange other) {
        return other.end > this.start && other.start < this.end;
    }

    public String toString() {
        return String.format("DateRange[%s - %s]", this.getStart(), this.getEnd());
    }

    public static enum StandardDateRange {
        NONE(Period.NONE, 0),
        LAST_HOUR(Period.HOURLY, -1),
        CURRENT_HOUR(Period.HOURLY, 0),
        BEFORE_YESTERDAY(Period.DAYLY, -2),
        YESTERDAY(Period.DAYLY, -1),
        TODAY(Period.DAYLY, 0),
        LAST_WEEK(Period.WEEKLY, -1),
        CURRENT_WEEK(Period.WEEKLY, 0),
        LAST_FORTNIGHT(new Period(2, Period.Unit.WEEK), -1),
        CURRENT_FORTNIGHT(new Period(2, Period.Unit.WEEK), 0),
        LAST_MONTH(Period.MONTHLY, -1),
        CURRENT_MONTH(Period.MONTHLY, 0),
        LAST_QUARTER(Period.QUARTERLY, -1),
        CURRENT_QUARTER(Period.QUARTERLY, 0),
        LAST_HALF_YEAR(Period.HALF_YEARLY, -1),
        CURRENT_HALF_YEAR(Period.HALF_YEARLY, 0),
        LAST_YEAR(Period.YEARLY, -1),
        CURRENT_YEAR(Period.YEARLY, 0);

        private final Period period;
        private final int fieldAddition;

        private StandardDateRange(Period period, int fieldAddition) {
            this.period = period;
            this.fieldAddition = fieldAddition;
        }

        public final int getFieldAddition() {
            return this.fieldAddition;
        }

        public final Period getPeriod() {
            return this.period;
        }
    }
}

