/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.datatype;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.logging.Log;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericEnum<E extends GenericEnum<E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Map<String, GenericEnum<?>>> enumRegistry = new LinkedHashMap();
    private final String name;

    protected GenericEnum(String name) {
        assert (this.getEnumBaseClass().isAssignableFrom(this.getClass())) : "Wrong enum class hierarchy: " + this.getClass() + " is not a subclass of " + this.getEnumBaseClass();
        Map<String, GenericEnum<GenericEnum<?>>> enums = GenericEnum.getValueMap(this.getEnumBaseClass(), true);
        assert (enums.get(name) == null) : "Duplicate enum value: " + name + " in class " + this.getClass().getName() + (this.getEnumBaseClass() != this.getClass() ? " (Base: " + this.getEnumBaseClass().getName() + ")" : "");
        this.name = name;
        enums.put(name, this);
        assert (this.checkEnumStructure());
    }

    public static boolean assertEnumInstances(Class<?> declaringClass) {
        GenericEnum.checkEnumInstances(declaringClass);
        return true;
    }

    private static Field checkEnumInstances(Class<?> declaringClass) {
        Field[] fields = declaringClass.getDeclaredFields();
        Field nullField = null;
        int nullCnt = 0;
        for (Field field : fields) {
            if (!GenericEnum.class.isAssignableFrom(field.getType())) continue;
            String name = field.getName();
            int modifier = field.getModifiers();
            Object value = null;
            assert (Modifier.isFinal(modifier) && Modifier.isStatic(modifier)) : "Enum instance not final static: " + name;
            try {
                value = field.get(null);
            }
            catch (Exception e) {
                Log.debug("Could not assert enum value " + name, e);
                continue;
            }
            if (value != null) {
                GenericEnum genericEnum = (GenericEnum)value;
                assert (genericEnum.name.equals(name)) : "Name mismatch of GenericEnum " + name + " (wrong name: " + genericEnum + ")";
                continue;
            }
            ++nullCnt;
            nullField = field;
        }
        return nullCnt == 1 ? nullField : null;
    }

    private static Map<String, GenericEnum<?>> getValueMap(Class<?> enumClass) {
        Class<?> base;
        for (base = enumClass; base != GenericEnum.class; base = base.getSuperclass()) {
            try {
                base.getDeclaredMethod("getEnumBaseClass", new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (base != GenericEnum.class) {
            enumClass = base;
        }
        return GenericEnum.getValueMap(enumClass, false);
    }

    private static Map<String, GenericEnum<?>> getValueMap(Class<?> enumBaseClass, boolean create) {
        String iD = enumBaseClass.getName();
        Map<String, GenericEnum<?>> valueMap = enumRegistry.get(iD);
        if (valueMap == null && create) {
            valueMap = new LinkedHashMap();
            enumRegistry.put(iD, valueMap);
        }
        return valueMap;
    }

    public static Collection<GenericEnum<?>> getValues(Class<? extends GenericEnum<?>> enumClass) {
        Map<String, GenericEnum<GenericEnum<?>>> valueMap = GenericEnum.getValueMap(enumClass);
        if (valueMap != null) {
            return Collections.unmodifiableCollection(valueMap.values());
        }
        return Collections.emptyList();
    }

    @SafeVarargs
    protected static <T extends GenericEnum<T>> List<T> listOf(T ... values) {
        return CollectionUtil.fixedListOf((Object[])values);
    }

    @SafeVarargs
    protected static <T extends GenericEnum<T>> Set<T> setOf(T ... values) {
        return CollectionUtil.fixedSetOf((Object[])values);
    }

    public static GenericEnum<?> valueOf(Class<? extends GenericEnum<?>> enumClass, String name) {
        Map<String, GenericEnum<GenericEnum<?>>> valueMap = GenericEnum.getValueMap(enumClass);
        GenericEnum<? extends GenericEnum<?>> genericEnum = null;
        if (valueMap != null) {
            genericEnum = valueMap.get(name);
        }
        if (genericEnum == null) {
            throw new IllegalArgumentException(name + " is not a valid instance name of " + enumClass);
        }
        return genericEnum;
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public E next(boolean wrap) {
        Class<GenericEnum<?>> baseClass = this.getEnumBaseClass();
        return (E)((GenericEnum)CollectionUtil.next(GenericEnum.getValueMap(baseClass, false).values(), (Object)this, (boolean)wrap));
    }

    public E previous(boolean wrap) {
        Class<GenericEnum<?>> c = this.getEnumBaseClass();
        return (E)((GenericEnum)CollectionUtil.previous(GenericEnum.getValueMap(c, false).values(), (Object)this, (boolean)wrap));
    }

    public String toString() {
        return this.name;
    }

    protected Class<? extends GenericEnum<?>> getEnumBaseClass() {
        return this.getClass();
    }

    protected final Object readResolve() throws ObjectStreamException {
        return GenericEnum.getValueMap(this.getEnumBaseClass(), true).get(this.name);
    }

    private boolean checkEnumStructure() {
        Field nullField = GenericEnum.checkEnumInstances(this.getClass());
        assert (nullField == null || nullField.getName().equals(this.name)) : "Name mismatch of instance " + nullField.getName() + " (wrong name: " + this.name + ")";
        return true;
    }
}

