/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EchoInputStream
extends FilterInputStream {
    private final OutputStream echoStream;

    public EchoInputStream(InputStream wrappedStream, OutputStream echoStream) {
        super(wrappedStream);
        this.echoStream = echoStream;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b >= 0) {
            this.echoStream.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = super.read(buffer, offset, length);
        if (read >= 0) {
            this.echoStream.write(buffer, offset, read);
        }
        return read;
    }
}

