/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class EchoReader
extends FilterReader {
    private final Writer echoWriter;

    public EchoReader(Reader wrappedReader, Writer echoWriter) {
        super(wrappedReader);
        this.echoWriter = echoWriter;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch >= 0) {
            this.echoWriter.write(ch);
        }
        return ch;
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        int read = super.read(buffer, offset, length);
        if (read >= 0) {
            this.echoWriter.write(buffer, offset, read);
        }
        return read;
    }
}

