/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.expression.Predicate;
import de.esoco.lib.text.TextUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class IOFunctions {
    private IOFunctions() {
    }

    public static PatternFilenameFilter ifFilenameLike(String regex) {
        Pattern pattern = Pattern.compile(TextUtil.simplePatternToRegEx((String)regex));
        return new PatternFilenameFilter(pattern);
    }

    public static PatternFilenameFilter ifFilenameMatches(String regex) {
        return new PatternFilenameFilter(Pattern.compile(regex));
    }

    public static class PatternFilenameFilter
    implements Predicate<File>,
    FilenameFilter {
        private final Pattern pattern;

        private PatternFilenameFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File path, String name) {
            return this.pattern.matcher(name).matches();
        }

        public Boolean evaluate(File file) {
            return this.accept(file.getParentFile(), file.getName());
        }
    }
}

