/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.io.StreamLimitException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private int remainingLength;

    public LimitedInputStream(InputStream wrappedStream, int max) {
        super(wrappedStream);
        this.remainingLength = max;
    }

    public int getRemainingLimit() {
        return this.remainingLength;
    }

    @Override
    public int read() throws IOException {
        this.checkLimit();
        --this.remainingLength;
        return super.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.checkLimit();
        if (this.remainingLength < length) {
            length = this.remainingLength;
        }
        int read = super.read(buffer, offset, length);
        this.remainingLength -= read;
        return read;
    }

    public String toString() {
        return String.format("%s(%d, %s)", this.getClass().getSimpleName(), this.remainingLength, this.in);
    }

    protected void checkLimit() throws StreamLimitException {
        if (this.remainingLength == 0) {
            throw new StreamLimitException("Input limit reached", true);
        }
    }
}

