/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.io.StreamLimitException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream {
    private int remainingLimit;

    public LimitedOutputStream(OutputStream wrappedStream, int maxBytes) {
        super(wrappedStream);
        this.remainingLimit = maxBytes;
    }

    public int getRemainingLimit() {
        return this.remainingLimit;
    }

    public String toString() {
        return String.format("%s(%d, %s)", this.getClass().getSimpleName(), this.remainingLimit, this.out);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remainingLimit-- <= 0) {
            throw new StreamLimitException("Output limit reached", false);
        }
        super.write(b);
    }
}

