/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.io.StreamLimitException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class LimitedReader
extends FilterReader {
    private int remainingLimit;

    public LimitedReader(Reader wrappedReader, int max) {
        super(wrappedReader);
        this.remainingLimit = max;
    }

    public int getRemainingLimit() {
        return this.remainingLimit;
    }

    @Override
    public int read() throws IOException {
        this.checkLimit();
        --this.remainingLimit;
        return super.read();
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        this.checkLimit();
        if (this.remainingLimit < length) {
            length = this.remainingLimit;
        }
        int read = super.read(buffer, offset, length);
        this.remainingLimit -= read;
        return read;
    }

    public String toString() {
        return String.format("%s(%d, %s)", this.getClass().getSimpleName(), this.remainingLimit, this.in);
    }

    protected void checkLimit() throws StreamLimitException {
        if (this.remainingLimit == 0) {
            throw new StreamLimitException("Input limit reached", true);
        }
    }
}

