/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.io.StreamLimitException;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LimitedWriter
extends FilterWriter {
    private int remainingLimit;

    public LimitedWriter(Writer wrappedWriter, int max) {
        super(wrappedWriter);
        this.remainingLimit = max;
    }

    public int getRemainingLimit() {
        return this.remainingLimit;
    }

    public String toString() {
        return String.format("%s(%d, %s)", this.getClass().getSimpleName(), this.remainingLimit, this.out);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remainingLimit-- <= 0) {
            throw new StreamLimitException("Output limit reached", false);
        }
        super.write(b);
    }
}

