/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.ThrowingBinaryFunction;
import de.esoco.lib.expression.ThrowingFunction;
import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.expression.predicate.ThrowingBinaryPredicate;
import de.esoco.lib.io.StreamUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StreamFunctions {
    private StreamFunctions() {
    }

    public static BinaryPredicate<InputStream, byte[]> find(byte[] defaultToken, int max) {
        return ThrowingBinaryPredicate.of((stream, token) -> StreamUtil.find(stream, (byte[])Option.of((Object)token).orUse((Object)defaultToken), max, null));
    }

    public static BinaryPredicate<Reader, String> find(String defaultToken, int max, boolean ignoreCase) {
        return ThrowingBinaryPredicate.of((stream, token) -> StreamUtil.find(stream, (String)Option.of((Object)token).orUse((Object)defaultToken), max, ignoreCase, null));
    }

    public static Function<InputStream, byte[]> readAll(int bufferSize, int maxLength) {
        return ThrowingFunction.of(input -> StreamUtil.readAll(input, bufferSize, maxLength));
    }

    public static BiFunction<Reader, String, String> readUntil(String defaultToken, int max, boolean ignoreCase) {
        return ThrowingBinaryFunction.of((reader, t) -> {
            StringWriter output = new StringWriter();
            String token = (String)Option.of((Object)t).orUse((Object)defaultToken);
            String result = null;
            if (StreamUtil.readUntil(reader, output, token, max, ignoreCase)) {
                result = ((Object)output).toString();
                result = result.substring(0, result.length() - token.length());
            }
            return result;
        });
    }
}

