/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import de.esoco.lib.collection.ByteArray;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class StreamUtil {
    public static boolean find(InputStream in, byte[] token, int max) throws IOException {
        return StreamUtil.find(in, token, max, null);
    }

    public static boolean find(Reader reader, String token, int max, boolean ignoreCase) throws IOException {
        return StreamUtil.find(reader, token, max, ignoreCase, null);
    }

    public static boolean find(InputStream in, byte[] token, int max, ReadHandler handler) throws IOException {
        int tokenLength = token.length;
        int read = 0;
        int pos = 0;
        if (tokenLength == 0) {
            throw new IllegalArgumentException("Invalid search token");
        }
        while (read != -1 && max-- > 0) {
            read = in.read();
            if (read == -1) continue;
            byte b = (byte)read;
            if (handler != null) {
                handler.valueRead(b);
            }
            if (b != token[pos++]) {
                pos = 0;
                continue;
            }
            if (pos != tokenLength) continue;
            return true;
        }
        return false;
    }

    public static boolean find(Reader input, String token, int max, boolean ignoreCase, ReadHandler handler) throws IOException {
        if (ignoreCase) {
            token = token.toLowerCase();
        }
        int tokenLength = token.length();
        char read = '\u0000';
        int pos = 0;
        if (tokenLength == 0) {
            throw new IllegalArgumentException("Invalid search token");
        }
        while (read != '\uffffffff' && max-- > 0) {
            read = input.read();
            if (read == -1) continue;
            char search = token.charAt(pos++);
            if (handler != null) {
                handler.valueRead(read);
            }
            if (ignoreCase) {
                read = Character.toLowerCase(read);
            }
            if (read != search) {
                pos = 0;
                continue;
            }
            if (pos != tokenLength) continue;
            return true;
        }
        return false;
    }

    public static byte[] readAll(InputStream in, int bufferSize, int max) throws IOException, IllegalArgumentException {
        int count;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be > 0");
        }
        ByteArray readBuffer = new ByteArray(bufferSize);
        byte[] bytes = new byte[bufferSize];
        int readMax = Math.min(max, bufferSize);
        while (max > 0 && (count = in.read(bytes, 0, readMax)) != -1) {
            readBuffer.add(bytes, 0, count);
            readMax = Math.min(max -= count, bufferSize);
        }
        return readBuffer.toByteArray();
    }

    public static String readAll(Reader in, int bufferSize, int max) throws IOException, IllegalArgumentException {
        int count;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be > 0");
        }
        StringBuilder result = new StringBuilder(bufferSize);
        char[] buffer = new char[bufferSize];
        int readMax = Math.min(max, bufferSize);
        while (max > 0 && (count = in.read(buffer, 0, readMax)) != -1) {
            result.append(buffer, 0, count);
            readMax = Math.min(max -= count, bufferSize);
        }
        return result.toString();
    }

    public static boolean readUntil(InputStream in, final OutputStream out, byte[] token, int max) throws IOException {
        return StreamUtil.find(in, token, max, new ReadHandler(){

            @Override
            public void valueRead(int b) {
                try {
                    out.write(b);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public static boolean readUntil(Reader in, final Writer out, String token, int max, boolean ignoreCase) throws IOException {
        return StreamUtil.find(in, token, max, ignoreCase, new ReadHandler(){

            @Override
            public void valueRead(int value) {
                try {
                    out.write(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public static void saveStream(InputStream stream, String outputFile, int max) throws IOException {
        int rd;
        FileOutputStream fo = new FileOutputStream(outputFile);
        while (max > 0 && (rd = stream.read()) >= 0) {
            fo.write(rd);
            --max;
        }
        fo.close();
    }

    public static long send(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        int read = 0;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
            count += (long)read;
        }
        return count;
    }

    public static long send(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        long count = 0L;
        int read = 0;
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
            count += (long)read;
        }
        return count;
    }

    public static abstract class ReadHandler {
        public abstract void valueRead(int var1);
    }
}

