/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private Writer writer;
    private String namespace = "";
    private final String indentation = "\t";
    private Stack<String> elementStack = new Stack();
    private boolean tagOpen = false;

    public XmlWriter(Writer writer) throws IOException {
        this(writer, "1.0", "UTF-8", Boolean.TRUE);
    }

    public XmlWriter(Writer writer, String version, String encoding, Boolean standalone) throws IOException {
        this.writer = writer;
        writer.write("<?xml version=\"");
        writer.write(version);
        if (encoding != null) {
            writer.write("\" encoding=\"");
            writer.write(encoding);
        }
        if (standalone != null) {
            writer.write("\" standalone=\"");
            writer.write(standalone != false ? "yes" : "no");
        }
        writer.write("\"?>\n");
    }

    public void close() throws IOException {
        if (!this.elementStack.isEmpty()) {
            throw new IOException("XML file contains unclosed elements: " + this.elementStack);
        }
        this.writer.flush();
        this.writer = null;
        this.elementStack = null;
    }

    public XmlWriter endElement() throws IOException {
        if (this.elementStack.isEmpty()) {
            throw new IOException("No open element");
        }
        String element = this.elementStack.pop();
        if (this.tagOpen) {
            this.writer.write("/>\n");
            this.tagOpen = false;
        } else {
            this.writer.write("</");
            this.writer.write(element);
            this.writer.write(">\n");
        }
        this.indent(this.elementStack.size() - 1);
        return this;
    }

    public final String getIndentation() {
        return "\t";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public final void setIndentation(String indentation) {
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public XmlWriter startElement(String name) throws IOException {
        if (this.namespace != null && this.namespace.length() > 0) {
            name = this.namespace + ":" + name;
        }
        if (this.tagOpen) {
            this.writer.write(">\n");
            this.indent(this.elementStack.size());
        } else {
            this.tagOpen = true;
            this.indent(1);
        }
        this.writer.write("<");
        this.writer.write(name);
        this.elementStack.push(name);
        return this;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.writer.getClass().getSimpleName());
    }

    public XmlWriter writeAttribute(String name, String value) throws IOException {
        if (!this.tagOpen) {
            throw new IOException("No open element tag");
        }
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(this.escapeCharacterEntities(value));
        this.writer.write("\"");
        return this;
    }

    public XmlWriter writeCharacterData(String data) throws IOException {
        int cDataTerminator = data.indexOf("]]>");
        if (cDataTerminator >= 0) {
            this.writeCharacterData(data.substring(0, cDataTerminator += 2));
            this.writeCharacterData(data.substring(cDataTerminator));
        } else {
            this.writeContent("<![CDATA[" + data + "]]>", true);
        }
        return this;
    }

    public XmlWriter writeComment(String comment) throws IOException {
        this.writeContent("<!--" + comment + "-->\n", false);
        this.indent(this.elementStack.size());
        return this;
    }

    public XmlWriter writeElement(String name, String text) throws IOException {
        this.startElement(name);
        if (text != null) {
            this.writeText(text);
        }
        return this.endElement();
    }

    public XmlWriter writeElement(String name, String attribute, String value, String text) throws IOException {
        this.startElement(name);
        this.writeAttribute(attribute, value);
        if (text != null) {
            this.writeText(text);
        }
        return this.endElement();
    }

    public XmlWriter writeText(String text) throws IOException {
        return this.writeContent(this.escapeCharacterEntities(text), true);
    }

    private String escapeCharacterEntities(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("'", "&apos;");
        return text;
    }

    private void indent(int level) throws IOException {
        if ("\t" != null) {
            for (int i = level; i > 0; --i) {
                this.writer.write("\t");
            }
        }
    }

    private XmlWriter writeContent(String content, boolean elementOnly) throws IOException {
        if (elementOnly && this.elementStack.isEmpty()) {
            throw new IOException("No open element");
        }
        if (this.tagOpen) {
            this.tagOpen = false;
            this.writer.write(">");
            if (content.length() > 0 && content.charAt(0) == '<') {
                this.writer.write("\n");
                this.indent(this.elementStack.size());
            }
        }
        this.writer.write(content);
        return this;
    }
}

