/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.Group;
import de.esoco.lib.logging.LogAspect;
import de.esoco.lib.logging.LogExtent;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.logging.LogLevelFilter;
import de.esoco.lib.logging.LogRecord;
import de.esoco.lib.logging.LogRecordFormat;
import de.esoco.lib.reflect.ReflectUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public final class Log {
    public static final RelationType<LogExtent> LOG_EXTENT = RelationTypes.newInitialValueType((Object)((Object)LogExtent.NOTHING), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<LogLevel> LOG_LEVEL = RelationTypes.newInitialValueType((Object)((Object)LogLevel.ERROR), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final LogRecordFormat DEFAULT_FORMAT = new LogRecordFormat("[{level:F%-5s}]{t:Dyyyy.MM.dd-HH:mm:ss}: {message}  [{package}.{class}.{method}() [{line}]]");
    public static final LogRecordFormat CAUSE_TRACE = new LogRecordFormat("{getCauseStackTrace():F%s\n}");
    private static final Object[] NO_ARGS = null;
    private static final Map<String, Consumer<? super LogRecord>> logHandlerRegistry = new HashMap<String, Consumer<? super LogRecord>>();
    private static final Map<String, Consumer<? super LogRecord>> logHandlerCache = new HashMap<String, Consumer<? super LogRecord>>();
    private static Consumer<LogRecord> standardLogHandler;
    private static Group<LogRecord> defaultLogHandlers;
    private static LogLevelFilter globalLevelFilter;
    private static Map<Class<? extends LogAspect>, LogAspect<?>> logAspects;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultLogHandler(Consumer<? super LogRecord> handler) {
        Objects.requireNonNull(handler);
        Map<String, Consumer<? super LogRecord>> map = logHandlerCache;
        synchronized (map) {
            List functions = defaultLogHandlers.getMembers();
            functions.add(handler);
            defaultLogHandlers = new Group((Collection)functions);
            logHandlerCache.clear();
        }
    }

    public static void addLogAspect(LogAspect<?> logAspect) {
        Class<?> logAspectType = ((Object)logAspect).getClass();
        if (logAspects == null) {
            logAspects = new HashMap();
        } else {
            Log.removeLogAspect(logAspectType);
        }
        logAspects.put(logAspectType, logAspect);
        logAspect.initLogging();
    }

    public static void debug(String message) {
        Log.logImpl(LogLevel.DEBUG, null, message, NO_ARGS);
    }

    public static void debug(String message, Throwable cause) {
        Log.logImpl(LogLevel.DEBUG, cause, "%s", message, NO_ARGS);
    }

    public static void debugf(String format, Object ... args) {
        Log.logImpl(LogLevel.DEBUG, null, format, args);
    }

    public static void debugf(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.DEBUG, cause, format, args);
    }

    public static void error(String message) {
        Log.logImpl(LogLevel.ERROR, null, "%s", message, NO_ARGS);
    }

    public static void error(String message, Throwable cause) {
        Log.logImpl(LogLevel.ERROR, cause, "%s", message, NO_ARGS);
    }

    public static void errorf(String format, Object ... args) {
        Log.logImpl(LogLevel.ERROR, null, format, args);
    }

    public static void errorf(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.ERROR, cause, format, args);
    }

    public static void fatal(String message) {
        Log.logImpl(LogLevel.FATAL, null, "%s", message, NO_ARGS);
    }

    public static void fatal(String message, Throwable cause) {
        Log.logImpl(LogLevel.FATAL, cause, "%s", message, NO_ARGS);
    }

    public static void fatalf(String format, Object ... args) {
        Log.logImpl(LogLevel.FATAL, null, format, args);
    }

    public static void fatalf(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.FATAL, cause, format, args);
    }

    private static Consumer<? super LogRecord> findLogHandler(String packageOrClass) {
        Consumer<? super LogRecord> handler;
        if (packageOrClass != null) {
            handler = logHandlerRegistry.get(packageOrClass);
            if (handler == null) {
                packageOrClass = ReflectUtil.getNamespace((String)packageOrClass);
                handler = Log.findLogHandler(packageOrClass);
            }
        } else {
            handler = Functions.asConsumer(defaultLogHandlers);
        }
        return handler;
    }

    public static LogLevel getGlobalMinimumLogLevel() {
        return globalLevelFilter.getMinimumLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Consumer<? super LogRecord> getLogHandler(LogRecord record) {
        String className = record.getLogClass().getName();
        Consumer<? super LogRecord> logHandler = null;
        Map<String, Consumer<? super LogRecord>> map = logHandlerCache;
        synchronized (map) {
            logHandler = logHandlerCache.get(className);
            if (logHandler == null) {
                logHandler = Log.findLogHandler(className);
                logHandlerCache.put(className, logHandler);
            }
        }
        return logHandler;
    }

    public static Consumer<? super LogRecord> getRegisteredLogHandler(String packageOrClass) {
        return logHandlerRegistry.get(packageOrClass);
    }

    public static Consumer<LogRecord> getStandardLogHandler() {
        return standardLogHandler;
    }

    public static void info(String message) {
        Log.logImpl(LogLevel.INFO, null, "%s", message, NO_ARGS);
    }

    public static void info(String message, Throwable cause) {
        Log.logImpl(LogLevel.INFO, cause, "%s", message, NO_ARGS);
    }

    public static void infof(String format, Object ... args) {
        Log.logImpl(LogLevel.INFO, null, format, args);
    }

    public static void infof(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.INFO, cause, format, args);
    }

    public static boolean isLevelEnabled(LogLevel level) {
        return globalLevelFilter.isLevelEnabled(level);
    }

    public static void log(LogLevel level, String message) {
        Log.logImpl(level, null, "%s", message, NO_ARGS);
    }

    public static void log(LogLevel level, String message, Throwable cause) {
        Log.logImpl(level, cause, "%s", message, NO_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logImpl(LogLevel level, Throwable cause, String messageFormat, Object ... messageValues) {
        Consumer<? super LogRecord> logHandler;
        LogRecord logRecord = null;
        if (globalLevelFilter.isLevelEnabled(level) && (logHandler = Log.getLogHandler(logRecord = new LogRecord(level, cause, messageFormat, messageValues))) != null) {
            Consumer<? super LogRecord> consumer = logHandler;
            synchronized (consumer) {
                logHandler.accept(logRecord);
            }
        }
    }

    public static void logf(LogLevel level, String format, Object ... args) {
        Log.logImpl(level, null, format, args);
    }

    public static void logf(LogLevel level, Throwable cause, String format, Object ... args) {
        Log.logImpl(level, cause, format, args);
    }

    public static void registerLogHandler(Class<?> type, Consumer<? super LogRecord> newHandler) {
        Log.registerLogHandler(type.getName(), newHandler);
    }

    public static void registerLogHandler(Package pkg, Consumer<? super LogRecord> newHandler) {
        Log.registerLogHandler(pkg.getName(), newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerLogHandler(String packageOrClass, Consumer<? super LogRecord> newHandler) {
        Map<String, Consumer<? super LogRecord>> map = logHandlerCache;
        synchronized (map) {
            if (newHandler != null) {
                logHandlerRegistry.put(packageOrClass, newHandler);
            } else {
                logHandlerRegistry.remove(packageOrClass);
            }
            logHandlerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDefaultLogHandler(Consumer<? super LogRecord> handler) {
        Map<String, Consumer<? super LogRecord>> map = logHandlerCache;
        synchronized (map) {
            List functions = defaultLogHandlers.getMembers();
            functions.remove(handler);
            defaultLogHandlers = new Group((Collection)functions);
            logHandlerCache.clear();
        }
    }

    public static void removeLogAspect(Class<? extends LogAspect<?>> logAspectType) {
        LogAspect<?> logAspect;
        if (logAspects != null && (logAspect = logAspects.remove(logAspectType)) != null) {
            logAspect.shutdownLogging();
        }
    }

    public static void removeStandardLogHandler() {
        Log.removeDefaultLogHandler(standardLogHandler);
    }

    public static void setGlobalLogLevels(LogLevel ... levels) {
        globalLevelFilter = LogLevelFilter.isLevel(EnumSet.of(LogLevel.FATAL, levels));
    }

    public static void setGlobalMinimumLogLevel(LogLevel level) {
        globalLevelFilter = LogLevelFilter.startingAt(level);
    }

    public static void setLogLevel(String packageOrClass, LogLevel level) {
        Log.registerLogHandler(packageOrClass, null);
        if (level != null) {
            Log.registerLogHandler(packageOrClass, (Consumer<? super LogRecord>)Functions.doIf((Predicate)LogLevelFilter.startingAt(level), Log.findLogHandler(packageOrClass)));
        }
    }

    private static void setupPackageLogHandlers() {
        String packageLevels = System.getProperty("esoco.log.plevels");
        if (packageLevels != null) {
            String[] pkgLevels;
            for (String packageLevel : pkgLevels = packageLevels.split(",")) {
                String[] pgkLevel = packageLevel.split("=");
                if (pgkLevel.length != 2) {
                    throw new IllegalArgumentException("Invalid package log pgkLevel: " + packageLevel);
                }
                String packageOrClass = pgkLevel[0];
                LogLevel logLevel = LogLevel.valueOf(pgkLevel[1]);
                if (packageOrClass == null) {
                    throw new IllegalArgumentException(String.format("Invalid log package definition: %s", packageLevel));
                }
                Log.setLogLevel(packageOrClass, logLevel);
            }
        }
    }

    private static void setupStandardLogHandler() {
        String level = System.getProperty("esoco.log.level");
        String file = System.getProperty("esoco.log.file");
        PrintWriter out = new PrintWriter(System.out);
        if (file != null) {
            try {
                out = new PrintWriter(new FileWriter(file, true));
            }
            catch (IOException e) {
                System.err.println("Log file not found, reverting to System.out");
                e.printStackTrace();
            }
        }
        LogRecordFormat stackTop = new LogRecordFormat("  at {stacktop}");
        Consumer standardLog = Functions.asConsumer((Function)Functions.println((PrintWriter)out, (String)"%s").from((de.esoco.lib.expression.Function)DEFAULT_FORMAT));
        Consumer traceLog = Functions.doIf((Predicate)LogLevelFilter.isLevel(LogLevel.TRACE), (Consumer)Functions.asConsumer((Function)Functions.println((PrintWriter)out, (String)"%s").from((de.esoco.lib.expression.Function)stackTop)));
        Consumer causeLog = Functions.doIfElse(LogRecord.HAS_CAUSE, (Consumer)Functions.asConsumer((Function)Functions.println((PrintWriter)out, (String)"%s").from((de.esoco.lib.expression.Function)CAUSE_TRACE)), (Consumer)traceLog);
        standardLogHandler = Functions.asConsumer((Function)Group.of((Consumer)standardLog, (Consumer[])new Consumer[]{causeLog}));
        defaultLogHandlers = Group.of(standardLogHandler, (Consumer[])new Consumer[0]);
        if (level != null) {
            try {
                Log.setGlobalMinimumLogLevel(LogLevel.valueOf(level));
            }
            catch (Exception e) {
                Log.error("Invalid log level system property: " + level, e);
            }
        }
    }

    public static void trace(String message) {
        Log.logImpl(LogLevel.TRACE, null, "%s", message, NO_ARGS);
    }

    public static void trace(String message, Throwable cause) {
        Log.logImpl(LogLevel.TRACE, cause, "%s", message, NO_ARGS);
    }

    public static void tracef(String format, Object ... args) {
        Log.logImpl(LogLevel.TRACE, null, format, args);
    }

    public static void tracef(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.TRACE, cause, format, args);
    }

    public static void warn(String message) {
        Log.logImpl(LogLevel.WARN, null, "%s", message, NO_ARGS);
    }

    public static void warn(String message, Throwable cause) {
        Log.logImpl(LogLevel.WARN, cause, "%s", message, NO_ARGS);
    }

    public static void warnf(String format, Object ... args) {
        Log.logImpl(LogLevel.WARN, null, format, args);
    }

    public static void warnf(Throwable cause, String format, Object ... args) {
        Log.logImpl(LogLevel.WARN, cause, format, args);
    }

    static {
        globalLevelFilter = LogLevelFilter.startingAt(LogLevel.ERROR);
        RelationTypes.init((Class[])new Class[]{Log.class});
        Log.setupStandardLogHandler();
        Log.setupPackageLogHandlers();
    }
}

