/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.expression.Action;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.logging.LogRecord;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public abstract class LogAspect<T>
extends RelatedObject {
    public static final RelationType<LogLevel> MIN_LOG_LEVEL = RelationTypes.newDefaultValueType(r -> Log.getGlobalMinimumLogLevel(), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<LogLevel> MIN_STACK_LOG_LEVEL = RelationTypes.newDefaultValueType((Object)((Object)LogLevel.ERROR), (RelationTypeModifier[])new RelationTypeModifier[0]);
    public static final RelationType<Integer> MAX_LOGGING_ERRORS = RelationTypes.newIntType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private boolean loggingInitialized = false;
    private int errorCount;
    private Lock queueAccessLock;
    private Queue<T> logQueue;
    private Action<LogRecord> logFunction;

    public final synchronized void initLogging() {
        if (!this.loggingInitialized) {
            this.errorCount = 0;
            this.queueAccessLock = new ReentrantLock();
            this.logQueue = new ConcurrentLinkedQueue<T>();
            this.logFunction = this::processLogRecord;
            this.init();
            String initMessage = this.getLogInitMessage();
            if (initMessage == null) {
                Log.info(initMessage);
            }
            Log.addDefaultLogHandler(this.logFunction);
            this.loggingInitialized = true;
        }
    }

    public final synchronized void shutdownLogging() {
        if (this.loggingInitialized) {
            Log.removeDefaultLogHandler(this.logFunction);
            this.shutdown();
            Log.infof("Log aspect %s has been shut down", new Object[]{this});
            this.loggingInitialized = false;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected abstract T createLogObject(LogRecord var1);

    protected String getLogInitMessage() {
        return String.format("Log aspect %s initialized, starting logging", new Object[]{this});
    }

    protected void init() {
    }

    protected abstract void processLogObjects(Collection<T> var1) throws Exception;

    protected void shutdown() {
    }

    private void processLogQueue() {
        block3: {
            try {
                if (!this.logQueue.isEmpty()) {
                    this.processLogObjects(this.logQueue);
                }
                this.logQueue.clear();
            }
            catch (Exception e) {
                if (++this.errorCount < (Integer)this.get(MAX_LOGGING_ERRORS)) break block3;
                this.shutdownLogging();
                Log.fatalf(e, "Log aspect %s failed, stopped after %d errors", ((Object)((Object)this)).getClass().getSimpleName(), this.errorCount);
            }
        }
    }

    private Object processLogRecord(LogRecord logRecord) {
        T logObject;
        if (logRecord.getLevel().compareTo((LogLevel)((Object)this.get(MIN_LOG_LEVEL))) >= 0 && (logObject = this.createLogObject(logRecord)) != null) {
            this.logQueue.add(logObject);
            if (this.queueAccessLock.tryLock()) {
                try {
                    this.processLogQueue();
                }
                finally {
                    this.queueAccessLock.unlock();
                }
            }
        }
        return logRecord;
    }

    static {
        RelationTypes.init((Class[])new Class[]{LogAspect.class});
    }
}

