/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.logging.LogRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public class LogLevelFilter
implements Predicate<LogRecord> {
    private final Set<LogLevel> logLevels;

    private LogLevelFilter(Set<LogLevel> levels) {
        this.logLevels = levels;
        this.logLevels.add(LogLevel.FATAL);
    }

    public static LogLevelFilter isLevel(Collection<LogLevel> levels) {
        return new LogLevelFilter(EnumSet.copyOf(levels));
    }

    public static LogLevelFilter isLevel(LogLevel ... levels) {
        return LogLevelFilter.isLevel(Arrays.asList(levels));
    }

    public static LogLevelFilter startingAt(LogLevel level) {
        return new LogLevelFilter(EnumSet.range(level, LogLevel.FATAL));
    }

    public Boolean evaluate(LogRecord record) {
        return this.isLevelEnabled(record.getLevel());
    }

    public LogLevel getMinimumLevel() {
        return (LogLevel)((Object)CollectionUtil.firstElementOf(this.logLevels));
    }

    public final boolean isLevelEnabled(LogLevel level) {
        return this.logLevels.contains((Object)level);
    }
}

