/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.expression.Predicate;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogLevel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class LogRecord {
    public static final Predicate<LogRecord> HAS_CAUSE = r -> r.getCause() != null;
    private static final int MAX_CAUSE_STACK_SIZE = 50;
    private static int stackOverhead = -1;
    private final LogLevel level;
    private final String messageFormat;
    private final Object[] messageValues;
    private final Throwable cause;
    private final long time;
    private final Thread logThread;
    private final StackTraceElement[] logStack;

    public LogRecord(LogLevel level, Throwable cause, String messageFormat, Object ... messageValues) {
        this.level = level;
        this.cause = cause;
        this.messageFormat = messageFormat;
        this.messageValues = messageValues;
        this.time = System.currentTimeMillis();
        this.logThread = Thread.currentThread();
        StackTraceElement[] stackTrace = this.logThread.getStackTrace();
        if (stackOverhead == -1) {
            stackOverhead = LogRecord.getStackOverhead(this.getClass().getPackage(), stackTrace);
        }
        int length = stackTrace.length - stackOverhead;
        this.logStack = new StackTraceElement[length];
        System.arraycopy(stackTrace, stackOverhead, this.logStack, 0, length);
    }

    public static int getStackOverhead(Package pkg, StackTraceElement[] stackTrace) {
        int overhead;
        String packageName = pkg.getName();
        int max = stackTrace.length - 1;
        for (overhead = 0; overhead < max && !stackTrace[overhead].getClassName().startsWith(packageName); ++overhead) {
        }
        while (overhead < max && stackTrace[overhead].getClassName().startsWith(packageName)) {
            ++overhead;
        }
        return overhead;
    }

    public String format(LogLevel minStackLevel) {
        String log = (String)Log.DEFAULT_FORMAT.apply(this);
        if (this.level.compareTo(minStackLevel) >= 0) {
            log = log + "\n" + Log.CAUSE_TRACE.evaluate(this);
        }
        return log;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public List<String> getCauseStackTrace() {
        ArrayList<String> fullStackTrace = new ArrayList<String>();
        String prefix = "\t| ";
        block0: for (Throwable e = this.cause; e != null; e = e.getCause()) {
            int stackElements = 0;
            fullStackTrace.add("   Caused by " + e);
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                fullStackTrace.add(prefix + stackTraceElement.toString());
                if (++stackElements >= 50) continue block0;
            }
        }
        return fullStackTrace;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public int getLineNumber() {
        return this.getLogLocation().getLineNumber();
    }

    public Class<?> getLogClass() {
        try {
            return Class.forName(this.getLogLocation().getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError();
        }
    }

    public String getLogClassName() {
        String name = this.getLogLocation().getClassName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public StackTraceElement getLogLocation() {
        return this.logStack[0];
    }

    public String getLogMethod() {
        return this.getLogLocation().getMethodName();
    }

    public String getLogPackage() {
        String className = this.getLogLocation().getClassName();
        int pos = className.lastIndexOf(46);
        if (pos > 0) {
            return className.substring(0, pos);
        }
        return "";
    }

    public StackTraceElement[] getLogStackTrace() {
        return this.logStack;
    }

    public Thread getLogThread() {
        return this.logThread;
    }

    public String getMessage() {
        return this.messageValues != null ? String.format(this.messageFormat, this.messageValues) : this.messageFormat;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public Object[] getMessageValues() {
        return this.messageValues;
    }

    public String getSourceFileName() {
        return this.getLogLocation().getFileName();
    }

    public long getTime() {
        return this.time;
    }

    public String toString() {
        String sb = "LogRecord[" + (Object)((Object)this.level) + ',' + DateFormat.getInstance().format(new Date(this.time)) + ',' + "\"" + this.getMessage() + "\"]";
        return sb;
    }
}

