/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.logging.LogAspect;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.logging.LogRecord;
import java.io.Writer;
import java.util.Collection;
import java.util.function.Supplier;

public class StreamLogging
extends LogAspect<String> {
    private final Supplier<Writer> getWriter;

    public StreamLogging(Supplier<Writer> getWriter) {
        this.getWriter = getWriter;
    }

    @Override
    protected String createLogObject(LogRecord logRecord) {
        return logRecord.format((LogLevel)((Object)this.get(MIN_STACK_LOG_LEVEL)));
    }

    @Override
    protected void processLogObjects(Collection<String> logs) throws Exception {
        try (Writer output = this.getWriter.get();){
            for (String log : logs) {
                output.write(log);
                output.write(10);
            }
            output.flush();
        }
    }
}

