/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.manage;

import de.esoco.lib.collection.CacheMap;
import de.esoco.lib.collection.ReferenceCacheMap;
import java.util.Map;

public class MultiLevelCache<K, V> {
    private final CacheMap<K, V> firstLevelMap;
    private final ReferenceCacheMap<K, V> secondLevelMap;
    private final ReferenceCacheMap<K, V> thirdLevelMap;

    public MultiLevelCache(int firstLevelCapacity, int secondLevelCapacity, int thirdLevelCapacity) {
        this.firstLevelMap = new CacheMap(firstLevelCapacity);
        this.secondLevelMap = new ReferenceCacheMap(secondLevelCapacity, true);
        this.thirdLevelMap = new ReferenceCacheMap(thirdLevelCapacity, false);
    }

    public void clear() {
        this.thirdLevelMap.clear();
        this.secondLevelMap.clear();
        this.firstLevelMap.clear();
    }

    public boolean contains(K key) {
        return this.firstLevelMap.containsKey(key) || this.secondLevelMap.containsKey(key) || this.thirdLevelMap.containsKey(key);
    }

    public final synchronized V get(K key) {
        V value = null;
        if (this.firstLevelMap.containsKey(key)) {
            value = this.firstLevelMap.get(key);
        } else if (this.secondLevelMap.containsKey(key)) {
            value = this.getReferenceValue(key, this.secondLevelMap);
        } else if (this.thirdLevelMap.containsKey(key)) {
            value = this.getReferenceValue(key, this.thirdLevelMap);
        }
        return value;
    }

    public int[] getCapacity() {
        return new int[]{this.firstLevelMap.getCapacity(), this.secondLevelMap.getCapacity(), this.thirdLevelMap.getCapacity()};
    }

    public String getUsage() {
        return String.format("%d/%d, %d/%d, %s/%d", this.firstLevelMap.size(), this.firstLevelMap.getCapacity(), this.secondLevelMap.size(), this.secondLevelMap.getCapacity(), this.thirdLevelMap.size(), this.thirdLevelMap.getCapacity());
    }

    public final synchronized void put(K key, V value) {
        this.remove(key);
        int firstLevelCapacity = this.firstLevelMap.getCapacity();
        if (firstLevelCapacity > 0) {
            if (this.firstLevelMap.size() == firstLevelCapacity) {
                this.saveEldest();
            }
            this.firstLevelMap.put(key, value);
        } else {
            this.putReference(key, value);
        }
    }

    public final synchronized V remove(K key) {
        Object oldValue = this.firstLevelMap.remove(key);
        oldValue = this.checkRemoveReference(key, oldValue, this.secondLevelMap);
        oldValue = this.checkRemoveReference(key, oldValue, this.thirdLevelMap);
        return oldValue;
    }

    public void setCapacity(int firstLevel, int secondLevel, int thirdLevel) {
        if (secondLevel > this.secondLevelMap.getCapacity()) {
            this.secondLevelMap.setCapacity(secondLevel);
        }
        if (thirdLevel > this.thirdLevelMap.getCapacity()) {
            this.thirdLevelMap.setCapacity(thirdLevel);
        }
        while (this.firstLevelMap.size() > firstLevel) {
            this.saveEldest();
        }
        if (thirdLevel > 0) {
            while (this.secondLevelMap.size() > secondLevel) {
                Object value;
                Map.Entry eldest = this.secondLevelMap.removeEldest();
                if (eldest == null || (value = ((ReferenceCacheMap.MappedReference)eldest.getValue()).get()) == null) continue;
                this.thirdLevelMap.putValue(eldest.getKey(), value);
            }
        }
        this.firstLevelMap.setCapacity(firstLevel);
        this.secondLevelMap.setCapacity(secondLevel);
        this.thirdLevelMap.setCapacity(thirdLevel);
    }

    public String toString() {
        return "Cache[" + this.getUsage() + ']';
    }

    private V checkRemoveReference(K key, V oldValue, ReferenceCacheMap<K, V> referenceMap) {
        Object reference = referenceMap.remove(key);
        if (oldValue == null && reference != null) {
            oldValue = reference.get();
        }
        return oldValue;
    }

    private V getReferenceValue(K key, ReferenceCacheMap<K, V> referenceMap) {
        Object reference = referenceMap.remove(key);
        V value = null;
        if (reference != null && (value = (V)reference.get()) != null) {
            this.put(key, value);
        }
        return value;
    }

    private void putReference(K key, V value) {
        Object eldestValue;
        Map.Entry eldest;
        int secondLevelCapacity = this.secondLevelMap.getCapacity();
        int thirdLevelCapacity = this.thirdLevelMap.getCapacity();
        if (this.secondLevelMap.size() == secondLevelCapacity && (eldest = this.secondLevelMap.removeEldest()) != null && thirdLevelCapacity > 0 && (eldestValue = ((ReferenceCacheMap.MappedReference)eldest.getValue()).get()) != null) {
            if (this.thirdLevelMap.size() == thirdLevelCapacity) {
                this.thirdLevelMap.removeEldest();
            }
            this.thirdLevelMap.putValue(eldest.getKey(), eldestValue);
        }
        if (this.secondLevelMap.getCapacity() > 0) {
            this.secondLevelMap.putValue(key, value);
        } else if (thirdLevelCapacity > 0) {
            this.thirdLevelMap.putValue(key, value);
        }
    }

    private void saveEldest() {
        Map.Entry<K, V> eldest = this.firstLevelMap.removeEldest();
        if (eldest != null) {
            this.putReference(eldest.getKey(), eldest.getValue());
        }
    }
}

