/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.manage;

import de.esoco.lib.manage.Closeable;
import de.esoco.lib.manage.Disposable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResourceManager
implements Disposable {
    Map<Object, ReferenceCount> resourceMap = new HashMap<Object, ReferenceCount>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object iD, Object object) {
        Map<Object, ReferenceCount> map = this.resourceMap;
        synchronized (map) {
            ReferenceCount rc = this.resourceMap.get(iD);
            if (rc == null) {
                rc = new ReferenceCount(object);
                this.resourceMap.put(iD, rc);
            } else {
                rc.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<Object, ReferenceCount> map = this.resourceMap;
        synchronized (map) {
            Iterator<ReferenceCount> i = this.resourceMap.values().iterator();
            while (i.hasNext()) {
                ReferenceCount rc = i.next();
                i.remove();
                this.disposeObject(rc.getObject());
            }
        }
    }

    public Object get(Object iD) {
        ReferenceCount rc = this.resourceMap.get(iD);
        if (rc != null) {
            return rc.getObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object iD) {
        Map<Object, ReferenceCount> map = this.resourceMap;
        synchronized (map) {
            ReferenceCount rc = this.resourceMap.get(iD);
            if (rc != null && rc.decrement()) {
                Object object = this.resourceMap.remove(iD).getObject();
                this.disposeObject(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object iD) {
        Map<Object, ReferenceCount> map = this.resourceMap;
        synchronized (map) {
            if (this.resourceMap.containsKey(iD)) {
                Object object = this.resourceMap.remove(iD).getObject();
                this.disposeObject(object);
            }
        }
    }

    private void disposeObject(Object object) {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        }
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        } else {
            try {
                Method dispose = object.getClass().getMethod("dispose", new Class[0]);
                dispose.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException dispose) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ReferenceCount {
        private final Object object;
        private int count = 0;

        public ReferenceCount(Object object) {
            this.object = object;
            this.increment();
        }

        public final boolean decrement() {
            return --this.count == 0;
        }

        public final Object getObject() {
            return this.object;
        }

        public final void increment() {
            ++this.count;
        }

        public String toString() {
            return "ReferenceCount[" + this.count + "]";
        }
    }
}

