/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.manage;

import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.Releasable;
import de.esoco.lib.manage.TransactionException;
import de.esoco.lib.manage.Transactional;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;

public class Transaction
implements Transactional {
    private static int nextTransactionId = 1;
    private final int id = nextTransactionId++;
    private Queue<Transactional> transactionElements = new LinkedList<Transactional>();
    private Queue<Releasable> releasableElements = new LinkedList<Releasable>();
    private int level = 1;
    private boolean committing = false;

    Transaction() {
    }

    public final void addElement(Transactional element) {
        this.checkActive();
        if (element == null) {
            throw new IllegalArgumentException("Element must not be NULL");
        }
        if (!this.transactionElements.contains(element)) {
            this.transactionElements.add(element);
        }
        if (element instanceof Releasable) {
            this.releasableElements.add((Releasable)((Object)element));
        }
    }

    @Override
    public final void commit() throws TransactionException {
        assert (this.level >= 0) : "Invalid transaction level: " + this.level;
        if (--this.level == 0 && !this.committing) {
            this.committing = true;
            this.endTransaction(true);
        }
    }

    public final Collection<Transactional> getElements() {
        if (this.transactionElements != null) {
            return Collections.unmodifiableCollection(this.transactionElements);
        }
        return Collections.emptyList();
    }

    public final int getLevel() {
        return this.level;
    }

    public final boolean isFinished() {
        return this.level == 0 && !this.hasActiveElements();
    }

    public final void removeElement(Transactional element) {
        this.checkActive();
        if (element == null) {
            throw new IllegalArgumentException("Element must not be NULL");
        }
        this.transactionElements.remove(element);
    }

    @Override
    public final void rollback() throws TransactionException {
        assert (this.level >= 0) : "Invalid transaction level: " + this.level;
        if (this.level == 0) {
            throw new IllegalStateException("Transaction already rolled back completely");
        }
        --this.level;
        if (this.hasActiveElements()) {
            this.endTransaction(false);
        }
    }

    public String toString() {
        return String.format("Transaction-%d[%d, %s]", this.id, this.level, this.transactionElements);
    }

    final boolean hasActiveElements() {
        return this.transactionElements != null;
    }

    final void incrementLevel() {
        this.checkActive();
        ++this.level;
    }

    private void checkActive() {
        if (!this.hasActiveElements()) {
            throw new IllegalStateException("Transaction not active");
        }
    }

    private void endTransaction(boolean commit) throws TransactionException {
        this.checkActive();
        try {
            while (!this.transactionElements.isEmpty()) {
                Transactional element = this.transactionElements.poll();
                if (commit) {
                    element.commit();
                    continue;
                }
                element.rollback();
            }
        }
        catch (Exception e) {
            this.rollbackRemainingElements();
            throw new TransactionException((commit ? "Commit" : "Rollback") + " failed", e);
        }
        finally {
            this.releaseElements();
            this.transactionElements = null;
        }
    }

    private void releaseElements() {
        while (!this.releasableElements.isEmpty()) {
            Releasable element = this.releasableElements.poll();
            try {
                element.release();
            }
            catch (Exception e) {
                Log.warn("Error on release of " + element, e);
            }
        }
        this.releasableElements = null;
    }

    private void rollbackRemainingElements() {
        if (this.transactionElements != null) {
            while (!this.transactionElements.isEmpty()) {
                Transactional element = this.transactionElements.poll();
                try {
                    element.rollback();
                }
                catch (Exception e) {
                    Log.error("Error on cleanup rollback of " + element, e);
                }
            }
        }
    }
}

