/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.manage;

import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.Transaction;
import de.esoco.lib.manage.TransactionException;
import de.esoco.lib.manage.Transactional;

public class TransactionManager {
    private static ThreadLocal<Transaction> threadTransaction = new ThreadLocal();

    private TransactionManager() {
    }

    public static void addTransactionElement(Transactional element) {
        TransactionManager.getTransaction().addElement(element);
    }

    public static Transaction begin() {
        Transaction transaction = threadTransaction.get();
        if (transaction == null) {
            transaction = new Transaction();
            threadTransaction.set(transaction);
        } else {
            transaction.incrementLevel();
        }
        Log.debugf("Begin transaction %s", transaction);
        return transaction;
    }

    public static Transaction beginUnmanagedTransaction() {
        return new Transaction();
    }

    public static void commit() throws TransactionException {
        Transaction transaction = TransactionManager.getTransaction();
        try {
            Log.debugf("Commit of %s", transaction);
            transaction.commit();
        }
        finally {
            if (transaction.isFinished()) {
                TransactionManager.removeTransaction(transaction);
            }
        }
    }

    public static Transaction getTransaction() {
        Transaction transaction = threadTransaction.get();
        if (transaction == null) {
            throw new IllegalStateException("Thread not in transaction");
        }
        return transaction;
    }

    public static boolean isInTransaction() {
        return threadTransaction.get() != null;
    }

    public static boolean isTransactionElement(Transactional element) {
        Transaction transaction = threadTransaction.get();
        return transaction != null && transaction.getElements().contains(transaction);
    }

    static void removeTransaction(Transaction transaction) {
        assert (TransactionManager.getTransaction() == transaction) : "Not current thread's transaction: " + transaction;
        threadTransaction.remove();
    }

    public static void removeTransactionElement(Transactional element) {
        TransactionManager.getTransaction().removeElement(element);
    }

    public static void rollback() throws TransactionException {
        Transaction transaction = TransactionManager.getTransaction();
        try {
            Log.debugf("Rollback of %s", transaction);
            transaction.rollback();
        }
        finally {
            if (transaction.isFinished()) {
                TransactionManager.removeTransaction(transaction);
            }
        }
    }

    public static void shutdown() {
        if (threadTransaction.get() != null) {
            threadTransaction.get().rollback();
        }
        threadTransaction = null;
    }
}

