/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.mapping;

import de.esoco.lib.mapping.MethodDatatypeMapper;
import de.esoco.lib.reflect.ReflectUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericMethodDatatypeMapper
implements MethodDatatypeMapper {
    private final Map<Class<?>, MappedTypes> mapping = new HashMap();

    @Override
    public boolean appliesTo(Method method, Class<?> datatype) {
        if (!this.mapping.containsKey(datatype)) {
            this.initMappedType(datatype);
        }
        return this.mapping.get(datatype) != null;
    }

    @Override
    public Class<?> mapType(Method method, Class<?> datatype) {
        return this.mapping.get(datatype).targetType;
    }

    @Override
    public Object mapValue(Object target, Method method, Object value) {
        Class<?> sourceType = this.mapping.get(value.getClass()).sourceType;
        String methodName = "map" + sourceType.getSimpleName();
        return ReflectUtil.invokePublic((Object)this, (String)methodName, (Object[])new Object[]{target, method, value}, (Class[])new Class[]{Object.class, Method.class, sourceType});
    }

    protected final void addMapping(Class<?> first, Class<?> second) {
        this.addOneWayMapping(first, second);
        this.addOneWayMapping(second, first);
    }

    protected final void addOneWayMapping(Class<?> source, Class<?> target) {
        assert (source != null);
        assert (target != null);
        this.mapping.put(source, new MappedTypes(source, target));
    }

    void initMappedType(Class<?> datatype) {
        Class<?> searchType = datatype;
        boolean search = true;
        while (search && searchType != null && !this.mapping.containsKey(searchType)) {
            for (Class<?> interfaceType : searchType.getInterfaces()) {
                if (this.mapping.get(interfaceType) == null) continue;
                searchType = interfaceType;
                search = false;
                break;
            }
            if (!search) continue;
            searchType = searchType.getSuperclass();
        }
        if (searchType != null) {
            Class<?> target = this.mapping.get(searchType).targetType;
            this.mapping.put(datatype, new MappedTypes(searchType, target));
        } else {
            this.mapping.put(datatype, null);
        }
    }

    private static class MappedTypes {
        Class<?> sourceType;
        Class<?> targetType;

        public MappedTypes(Class<?> sourceType, Class<?> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public String toString() {
            return "Mapping: " + this.sourceType + " <=> " + this.targetType;
        }
    }
}

