/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.mapping;

import de.esoco.lib.mapping.MethodDatatypeMapper;
import de.esoco.lib.mapping.MethodMappingHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMappingDefinition {
    public static final String IGNORE = "IGNORE";
    private static final MethodMappingHandler IGNORED_CALL_HANDLER = new MethodMappingHandler(){

        @Override
        protected Object invoke(Method originalMethod, Object target, Object[] args) throws Exception {
            return null;
        }
    };
    private final MethodMappingHandler defaultHandler = new MethodMappingHandler(this);
    private final List<MethodDatatypeMapper> datatypeMapping = new ArrayList<MethodDatatypeMapper>();
    private final Map<String, MethodMappingHandler> methodMapping = new HashMap<String, MethodMappingHandler>();

    public MethodMappingDefinition() {
    }

    public MethodMappingDefinition(Map<String, ?> mappingTable) {
        if (mappingTable != null) {
            for (String method : mappingTable.keySet()) {
                MethodMappingHandler handler;
                Object value = mappingTable.get(method);
                if (value instanceof String) {
                    handler = IGNORE.equals(value) ? IGNORED_CALL_HANDLER : new MethodMappingHandler((String)value);
                } else if (value instanceof MethodMappingHandler) {
                    handler = (MethodMappingHandler)value;
                } else {
                    throw new IllegalArgumentException("Invalid map entry type: " + value.getClass());
                }
                handler.setMappingDefinition(this);
                this.methodMapping.put(method, handler);
            }
        }
    }

    public MethodMappingDefinition(List<MethodDatatypeMapper> datatypeMapping) {
        this(null, datatypeMapping);
    }

    public MethodMappingDefinition(Map<String, ?> mappingTable, List<MethodDatatypeMapper> datatypeMapping) {
        this(mappingTable);
        if (datatypeMapping != null) {
            datatypeMapping.addAll(datatypeMapping);
        }
    }

    public MethodDatatypeMapper getDatatypeMapper(Method method, Class<?> datatype) {
        for (MethodDatatypeMapper mapper : this.datatypeMapping) {
            if (!mapper.appliesTo(method, datatype)) continue;
            return mapper;
        }
        return null;
    }

    public MethodMappingHandler getMappingHandler(Method method) {
        String name = method.getName();
        MethodMappingHandler handler = this.methodMapping.get(name);
        if (handler == null) {
            handler = this.defaultHandler;
            this.methodMapping.put(name, handler);
        }
        return handler;
    }

    public Object invoke(Method originalMethod, Object target, Object[] args) throws Exception {
        MethodMappingHandler handler = this.getMappingHandler(originalMethod);
        return handler.invoke(originalMethod, target, args);
    }

    public void merge(MethodMappingDefinition other) {
        for (MethodDatatypeMapper mapper : other.datatypeMapping) {
            if (this.datatypeMapping.contains(mapper)) continue;
            this.datatypeMapping.add(mapper);
        }
        for (String s : other.methodMapping.keySet()) {
            if (this.methodMapping.containsKey(s)) continue;
            this.methodMapping.put(s, other.methodMapping.get(s));
        }
    }
}

