/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.mapping;

import de.esoco.lib.mapping.MethodDatatypeMapper;
import de.esoco.lib.mapping.MethodMappingDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodMappingHandler {
    private MethodMappingDefinition mapping = null;
    private String targetMethod = null;

    public MethodMappingHandler() {
    }

    public MethodMappingHandler(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public MethodMappingHandler(MethodMappingDefinition mapping) {
        this.setMappingDefinition(mapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.targetMethod + "]";
    }

    protected Object invoke(Method originalMethod, Object target, Object[] args) throws Exception {
        try {
            target = this.mapTarget(originalMethod, target, args);
            Method method = this.mapMethod(originalMethod, this.targetMethod, target);
            args = this.mapArguments(originalMethod, target, method, args);
            Object value = this.invokeMethod(target, method, args);
            return this.mapReturnValue(originalMethod, target, method, value);
        }
        catch (InvocationTargetException iTE) {
            Throwable t = iTE.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    protected Object invokeMethod(Object target, Method targetMethod, Object[] args) throws Exception {
        return targetMethod.invoke(target, args);
    }

    protected Class<?>[] mapArgumentTypes(Method originalMethod, Class<?>[] argTypes, Object target) {
        for (int i = 0; i < argTypes.length; ++i) {
            MethodDatatypeMapper mapper = this.mapping.getDatatypeMapper(originalMethod, argTypes[i]);
            if (mapper == null) continue;
            argTypes[i] = mapper.mapType(originalMethod, argTypes[i]);
        }
        return argTypes;
    }

    protected Object[] mapArguments(Method originalMethod, Object target, Method targetMethod, Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                MethodDatatypeMapper mapper;
                Object value = args[i];
                if (value == null || (mapper = this.mapping.getDatatypeMapper(originalMethod, value.getClass())) == null) continue;
                args[i] = mapper.mapValue(target, originalMethod, value);
            }
        }
        return args;
    }

    protected Method mapMethod(Method originalMethod, String method, Object target) throws NoSuchMethodException {
        if (method == null) {
            method = originalMethod.getName();
        }
        Class<?>[] paramTypes = this.mapArgumentTypes(originalMethod, originalMethod.getParameterTypes(), target);
        return target.getClass().getMethod(method, paramTypes);
    }

    protected Object mapReturnValue(Method originalMethod, Object target, Method targetMethod, Object value) {
        MethodDatatypeMapper mapper;
        if (value != null && (mapper = this.mapping.getDatatypeMapper(originalMethod, value.getClass())) != null) {
            value = mapper.mapValue(target, originalMethod, value);
        }
        return value;
    }

    protected Object mapTarget(Method originalMethod, Object target, Object[] args) {
        return target;
    }

    void setMappingDefinition(MethodMappingDefinition mapping) {
        this.mapping = mapping;
    }
}

