/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.net;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.obrel.core.RelatedObject;

public class MACAddress
extends RelatedObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern mACPattern = Pattern.compile("(\\p{XDigit}{2}[:-]){5}\\p{XDigit}{2}");
    private byte[] bytes;

    public MACAddress(String mAC) {
        this.bytes = MACAddress.parseBytes(mAC);
    }

    public MACAddress(byte[] bytes) {
        if (bytes == null || bytes.length != 6) {
            bytes = new byte[6];
        }
        System.arraycopy(bytes, 0, bytes, 0, bytes.length);
    }

    public MACAddress(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6) {
        this.bytes = new byte[6];
        this.bytes[0] = b1;
        this.bytes[1] = b2;
        this.bytes[2] = b3;
        this.bytes[3] = b4;
        this.bytes[4] = b5;
        this.bytes[5] = b6;
    }

    public static byte[] parseBytes(String mAC) throws IllegalArgumentException {
        if (mAC == null || !mACPattern.matcher(mAC).matches()) {
            throw new IllegalArgumentException("Invalid MAC string: " + mAC);
        }
        String[] byteTokens = mAC.split("[:-]");
        byte[] bytes = new byte[6];
        assert (byteTokens.length == 6);
        for (int i = 0; i < 6; ++i) {
            bytes[i] = (byte)Integer.parseInt(byteTokens[i], 16);
        }
        return bytes;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, result, 0, this.bytes.length);
        return result;
    }
}

