/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.net;

import de.esoco.lib.io.StreamUtil;
import de.esoco.lib.net.MACAddress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NetUtil {
    public static final int WAKEONLAN_DEFAULT_PORT = 9;
    public static final String CRLF = "\r\n";
    private static final String TUNNELING_CHARSET = "ASCII7";
    private static final String JAVA_VERSION = "Java/" + System.getProperty("java.version");
    public static final String JAVA_USER_AGENT = System.getProperty("http.agent") == null ? JAVA_VERSION : System.getProperty("http.agent") + " " + JAVA_VERSION;
    public static String URL_ENCODING = StandardCharsets.UTF_8.name();

    private NetUtil() {
    }

    public static String appendUrlPath(String baseUrl, String path) {
        return NetUtil.appendUrlPath(new StringBuilder(baseUrl), path).toString();
    }

    public static StringBuilder appendUrlPath(StringBuilder urlBuilder, String path) {
        if (path != null && path.length() > 0) {
            if (urlBuilder.charAt(urlBuilder.length() - 1) != '/') {
                if (path.charAt(0) != '/') {
                    urlBuilder.append('/');
                }
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            urlBuilder.append(path);
        }
        return urlBuilder;
    }

    public static Socket createSocket(String host, int port, SocketType socketType) throws IOException {
        Socket socket;
        boolean sSL = socketType != SocketType.PLAIN;
        String proxyHost = System.getProperty(sSL ? "https.proxyHost" : "http.proxyHost");
        int proxyPort = 0;
        if (proxyHost != null) {
            proxyPort = Integer.parseInt(System.getProperty(sSL ? "https.proxyPort" : "http.proxyPort"));
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (nonProxyHosts != null) {
                nonProxyHosts = nonProxyHosts.replaceAll("\\.", "\\.");
                if (Pattern.matches(nonProxyHosts = nonProxyHosts.replaceAll("\\*", ".*"), host)) {
                    proxyHost = null;
                    proxyPort = 0;
                }
            }
        }
        if (sSL) {
            SSLSocketFactory factory = socketType == SocketType.SSL ? (SSLSocketFactory)SSLSocketFactory.getDefault() : NetUtil.getTrustingSocketFactory();
            socket = proxyHost != null ? NetUtil.createTunnelingSslSocket(factory, host, port, proxyHost, proxyPort) : factory.createSocket(host, port);
        } else if (proxyHost != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            socket = new Socket(proxy);
            socket.connect(new InetSocketAddress(host, port));
        } else {
            socket = SocketFactory.getDefault().createSocket(host, port);
        }
        return socket;
    }

    public static Socket createTunnelingSslSocket(SSLSocketFactory factory, String host, int port, String proxyHost, int proxyPort) throws IOException {
        Socket tunnelSocket = new Socket(proxyHost, proxyPort);
        NetUtil.initTunneling(tunnelSocket, host, port);
        SSLSocket socket = (SSLSocket)factory.createSocket(tunnelSocket, host, port, true);
        socket.startHandshake();
        return socket;
    }

    public static void enableHttpBasicAuth(URLConnection urlConnection, String userName, String password) {
        String auth = userName + ":" + password;
        auth = Base64.getEncoder().encodeToString(auth.getBytes());
        urlConnection.setRequestProperty("Authorization", "Basic " + auth);
    }

    public static String encodeUrlElement(String element) {
        try {
            return URLEncoder.encode(element, URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encodeUrlParameter(String name, String value) {
        return NetUtil.encodeUrlElement(name) + "=" + NetUtil.encodeUrlElement(value);
    }

    public static String encodeUrlParameters(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            result.append(NetUtil.encodeUrlParameter(param.getKey(), param.getValue()));
            result.append('&');
        }
        int length = result.length();
        if (length > 0) {
            result.setLength(length - 1);
        }
        return result.toString();
    }

    public static final SSLSocketFactory getTrustingSocketFactory() {
        SSLSocketFactory sslSocketFactory;
        try {
            TrustManager[] trustManagers = new TrustManager[]{new SelfSignedCertificateTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        return sslSocketFactory;
    }

    public static void initTunneling(Socket proxySocket, String host, int port) throws IOException {
        String request = String.format("CONNECT %s:%d HTTP/1.0\nUser-Agent: " + JAVA_USER_AGENT + "\r\n\r\n", host, port);
        OutputStream outputStream = proxySocket.getOutputStream();
        byte[] requestBytes = request.getBytes(TUNNELING_CHARSET);
        String reply = "";
        outputStream.write(requestBytes);
        outputStream.flush();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] replyBytes = null;
        if (StreamUtil.readUntil(proxySocket.getInputStream(), output, "\r\n\r\n".getBytes(TUNNELING_CHARSET), 512)) {
            replyBytes = output.toByteArray();
        }
        if (replyBytes != null) {
            reply = new String(replyBytes, TUNNELING_CHARSET);
        }
        if (!reply.startsWith("HTTP/1.0 200")) {
            throw new IOException(String.format("Cannot tunnel through %s:%d. Proxy response: %s", host, port, reply));
        }
    }

    public static void wakeUp(MACAddress mACAddress, InetAddress broadcastIP) throws IOException {
        NetUtil.wakeUp(mACAddress, broadcastIP, 9);
    }

    public static void wakeUp(MACAddress mACAddress, InetAddress broadcastIP, int port) throws IOException {
        int i;
        DatagramSocket socket = new DatagramSocket();
        byte[] mACBytes = mACAddress.getBytes();
        byte[] datagram = new byte[102];
        for (i = 0; i < 6; ++i) {
            datagram[i] = -1;
        }
        for (i = 6; i < datagram.length; i += 6) {
            System.arraycopy(mACBytes, 0, datagram, i, 6);
        }
        DatagramPacket packet = new DatagramPacket(datagram, datagram.length, broadcastIP, port);
        socket.send(packet);
        socket.close();
    }

    public static enum SocketType {
        PLAIN,
        SSL,
        SELF_SIGNED_SSL;

    }

    public static class SelfSignedCertificateTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

