/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.net;

import de.esoco.lib.logging.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Whois {
    private static final Set<String> recursiceLookupTlds = new HashSet<String>(Arrays.asList("com", "net"));
    private static final Map<String, String> whoisParamsMap = new HashMap<String, String>();
    private final Map<String, String> whoisServerMap = new HashMap<String, String>();

    public Whois(InputStream whoisServerListStream) {
        try {
            String line;
            BufferedReader serverList = new BufferedReader(new InputStreamReader(whoisServerListStream));
            while ((line = serverList.readLine()) != null) {
                String[] whoisServerRecord;
                if (line.startsWith("#") || (whoisServerRecord = line.split("\\|")).length <= 1) continue;
                String tld = whoisServerRecord[0];
                String server = whoisServerRecord[1];
                if (server.length() <= 0 || server.equals("NONE")) continue;
                this.whoisServerMap.put(tld, server);
                if (whoisServerRecord.length <= 2) continue;
                String params = whoisServerRecord[2];
                whoisParamsMap.put(tld, params);
            }
        }
        catch (FileNotFoundException e) {
            Log.warn("No WHOIS server list found, using Geektools", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not access WHOIS configuration");
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                Whois whois = new Whois(new FileInputStream("whois-server-list"));
                for (String domain : args) {
                    System.out.printf("--- Domain: %s ---\n", domain);
                    System.out.printf("%s", whois.query(domain));
                    System.out.print("-----------------------------------\n");
                }
            }
            catch (Exception e) {
                System.out.println("ERR: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.print("Usage: java Whois <domain names>\n");
        }
    }

    public WhoisRecord query(String domain) throws IOException {
        String tld = domain.substring(domain.indexOf(46) + 1);
        String server = this.whoisServerMap.get(tld);
        String params = whoisParamsMap.get(tld);
        if (server == null) {
            server = "whois.geektools.com";
        } else if (params != null) {
            domain = params + " " + domain;
        }
        WhoisRecord whoisRecord = new WhoisRecord(this.queryWhoisServer(server, domain));
        if (recursiceLookupTlds.contains(tld)) {
            server = whoisRecord.findValue("Whois Server:");
            if (server == null) {
                whoisRecord.getLines().add(0, "+++++++++++++++++++++++++++++");
                whoisRecord.getLines().add(1, "ERROR: No Detail WHOIS server");
                whoisRecord.getLines().add(2, "       found in master record");
                whoisRecord.getLines().add(3, "+++++++++++++++++++++++++++++");
            } else {
                whoisRecord.getLines().add("");
                whoisRecord.getLines().add("---------- Detail WHOIS from " + server + " -----------");
                whoisRecord.getLines().add("");
                whoisRecord.getLines().addAll(this.queryWhoisServer(server, domain));
            }
        }
        return whoisRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> queryWhoisServer(String server, String domain) throws IOException {
        Log.info("Using WHOIS server " + server);
        ArrayList<String> result = new ArrayList<String>();
        try (Socket socket = new Socket(server, 43);){
            String line;
            PrintStream out = new PrintStream(socket.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(domain);
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
            in.close();
        }
        return result;
    }

    public static class WhoisRecord {
        private final List<String> lines;

        public WhoisRecord(List<String> lines) {
            this.lines = lines;
        }

        public String findValue(String key) {
            String value = null;
            for (String line : this.lines) {
                int keyPosition = line.indexOf(key);
                if (keyPosition < 0) continue;
                value = line.substring(keyPosition + key.length()).trim();
            }
            return value;
        }

        public final List<String> getLines() {
            return this.lines;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (String line : this.lines) {
                result.append(line);
                result.append('\n');
            }
            return result.toString();
        }
    }
}

