/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.proxy.interception;

import de.esoco.lib.proxy.interception.Interception;
import java.lang.reflect.Method;

public abstract class InterceptionAdvice
implements Cloneable {
    InterceptionAdvice nextAdvice = null;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public final InterceptionAdvice getNextAdvice() {
        return this.nextAdvice;
    }

    public Object invoke(Interception interception, Object proxy, Method method, Object target, Object[] args) throws Exception {
        if (this.nextAdvice != null) {
            return this.nextAdvice.advise(interception, proxy, method, target, args);
        }
        return interception.invoke(proxy, method, target, args);
    }

    protected Object advise(Interception interception, Object proxy, Method method, Object target, Object[] args) throws Exception {
        Object result;
        this.before(target, method, args);
        try {
            result = this.invoke(interception, proxy, method, target, args);
        }
        catch (Throwable t) {
            this.afterThrow(t, target, method, args);
            throw t;
        }
        this.afterReturn(result, target, method, args);
        return result;
    }

    protected void after(Object invoked, Method method, Object[] args) throws Exception {
    }

    protected void afterReturn(Object toReturn, Object invoked, Method method, Object[] args) throws Exception {
        this.after(invoked, method, args);
    }

    protected void afterThrow(Throwable thrown, Object invoked, Method method, Object[] args) throws Exception {
        this.after(invoked, method, args);
    }

    protected void before(Object target, Method method, Object[] args) throws Exception {
    }

    final void setNextAdvice(InterceptionAdvice advice) {
        this.nextAdvice = advice;
    }
}

