/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.proxy.interception;

import de.esoco.lib.proxy.interception.Delegation;
import de.esoco.lib.proxy.interception.Interception;
import de.esoco.lib.proxy.interception.InterceptionAdvice;
import de.esoco.lib.proxy.interception.MethodInterception;
import de.esoco.lib.proxy.interception.RelatableInterception;
import de.esoco.lib.reflect.ReflectUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;

public class InterceptionProxy<T>
extends RelatedObject {
    public static final Interception FORWARD = new Delegation();
    public static final Interception IGNORE = new Interception(){

        @Override
        public Object invoke(Object proxy, Method originalMethod, Object target, Object[] args) throws Exception {
            return null;
        }
    };
    private final Class<?>[] proxyInterfaces;
    private final Map<Method, Interception> interceptions = new HashMap<Method, Interception>();
    InterceptionAdvice interceptionAdvice = null;
    private Interception defaultInterception = FORWARD;

    public InterceptionProxy(Class<T> interfaceType) {
        this.proxyInterfaces = new Class[]{interfaceType};
    }

    public InterceptionProxy(Class<T> interfaceType, boolean relationSupport) {
        this(interfaceType);
        if (relationSupport) {
            assert (Relatable.class.isAssignableFrom(interfaceType));
            this.setInterception(new RelatableInterception());
        }
    }

    public static Object getTarget(Object proxyInstance) {
        InvocationHandler ih = Proxy.getInvocationHandler(proxyInstance);
        if (ih instanceof InterceptionHandler) {
            return ((InterceptionHandler)ih).target;
        }
        throw new IllegalArgumentException("Not an interception proxy: " + proxyInstance);
    }

    public void addAdvice(InterceptionAdvice advice) {
        if (this.interceptionAdvice != null) {
            InterceptionAdvice next = advice.getNextAdvice();
            if (next != null && next != this.interceptionAdvice) {
                advice = (InterceptionAdvice)advice.clone();
            }
            advice.setNextAdvice(this.interceptionAdvice);
        }
        this.interceptionAdvice = advice;
    }

    public Interception getDefaultInterception() {
        return this.defaultInterception;
    }

    public Interception getInterception(Method method) {
        return this.interceptions.get(method);
    }

    public T newProxyInstance(Object target) {
        return (T)Proxy.newProxyInstance(this.proxyInterfaces[0].getClassLoader(), this.proxyInterfaces, (InvocationHandler)new InterceptionHandler(target));
    }

    public void setDefaultInterception(Interception defaultInterception) {
        this.defaultInterception = defaultInterception;
    }

    public void setInterception(MethodInterception interception) {
        for (Method method : interception.getMethodMap().keySet()) {
            this.setInterception(method, (Interception)interception);
        }
    }

    public void setInterception(String method, Interception interception) {
        List methodList = ReflectUtil.getPublicMethods(this.proxyInterfaces[0], (String)method);
        if (methodList.size() > 0) {
            for (Method m : methodList) {
                this.setInterception(m, interception);
            }
        } else {
            throw new IllegalArgumentException("No such method: " + method);
        }
    }

    public void setInterception(Method method, Interception interception) {
        if (method == null || !method.getDeclaringClass().isAssignableFrom(this.proxyInterfaces[0])) {
            throw new IllegalArgumentException("Invalid method: " + method);
        }
        if (interception == null) {
            throw new IllegalArgumentException("Interception must not be null");
        }
        this.interceptions.put(method, interception);
    }

    protected Interception getDefinedInterception(Method method) {
        Interception interception = this.getInterception(method);
        if (interception == null) {
            interception = this.defaultInterception;
        }
        if (interception == null) {
            throw new IllegalArgumentException("No interception for method " + method.getName());
        }
        return interception;
    }

    class InterceptionHandler
    extends RelatedObject
    implements InvocationHandler {
        final Object target;

        InterceptionHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Interception interception = InterceptionProxy.this.getDefinedInterception(method);
            if (interception instanceof RelatableInterception) {
                proxy = this;
            }
            if (InterceptionProxy.this.interceptionAdvice != null) {
                return InterceptionProxy.this.interceptionAdvice.advise(interception, proxy, method, this.target, args);
            }
            return interception.invoke(proxy, method, this.target, args);
        }
    }
}

