/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.proxy.interception;

import de.esoco.lib.proxy.interception.Interception;
import de.esoco.lib.reflect.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MethodInterception
implements Interception {
    private final Map<Method, Method> methodMap = new HashMap<Method, Method>();

    public MethodInterception(Method ... methods) {
        assert (methods != null && methods.length > 0);
        this.addMethods(Arrays.asList(methods), true);
    }

    public MethodInterception(Class<?> type) {
        this.addMethods(Arrays.asList(type.getDeclaredMethods()), true);
    }

    public MethodInterception(Class<?> type, String ... methods) {
        assert (methods.length > 0);
        for (String method : methods) {
            this.addMethod(type, method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method originalMethod, Object target, Object[] args) throws Exception {
        Object[] extArgs;
        Method method = this.methodMap.get(originalMethod);
        if (args != null) {
            extArgs = new Object[args.length + 2];
            System.arraycopy(args, 0, extArgs, 2, args.length);
        } else {
            extArgs = new Object[]{proxy, target};
        }
        return ReflectUtil.invoke((Object)this, (Method)method, (Object[])extArgs);
    }

    public String toString() {
        return "MethodInterception" + this.methodMap.keySet();
    }

    protected void addMethod(Method method) {
        Method targetMethod = this.mapMethod(method);
        if (targetMethod == null) {
            throw new IllegalArgumentException("Missing target method: " + method);
        }
        this.methodMap.put(method, targetMethod);
    }

    protected void addMethod(Class<?> type, String method) {
        List ml = ReflectUtil.getPublicMethods(type, (String)method);
        this.addMethods(ml, false);
    }

    protected void addMethods(Class<?> type) {
        this.addMethods(Arrays.asList(type.getDeclaredMethods()), true);
    }

    protected void addMethods(Collection<Method> methods, boolean publicOnly) {
        for (Method m : methods) {
            if (publicOnly && !Modifier.isPublic(m.getModifiers())) continue;
            this.addMethod(m);
        }
    }

    protected Class<?>[] convertArgTypes(Method method) {
        Class<?>[] argTypes = method.getParameterTypes();
        Class[] extArgTypes = new Class[argTypes.length + 2];
        System.arraycopy(argTypes, 0, extArgTypes, 2, argTypes.length);
        return extArgTypes;
    }

    protected Method mapMethod(Method method) {
        Class[] extArgTypes = this.convertArgTypes(method);
        return ReflectUtil.findPublicMethod(this.getClass(), (String)method.getName(), (Class[])extArgTypes);
    }

    Map<Method, Method> getMethodMap() {
        return this.methodMap;
    }
}

