/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.reflect;

import de.esoco.lib.reflect.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodDispatcher<T> {
    private final Object target;
    private final Method method;
    private boolean useArgs = true;

    public MethodDispatcher(Object target, String method) {
        this(target, method, null);
    }

    public MethodDispatcher(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public MethodDispatcher(Object target, String method, Class<?> ... paramTypes) {
        this(target, method, false, paramTypes);
    }

    protected MethodDispatcher(Object target, String method, boolean noParamsOptional, Class<?> ... paramTypes) {
        this.target = target;
        this.method = this.getMethod(target.getClass(), method, noParamsOptional, paramTypes);
    }

    public T dispatch() {
        return this.dispatch(null);
    }

    public T dispatch(Object ... args) {
        return (T)ReflectUtil.invoke((Object)this.target, (Method)this.method, (Object[])(this.useArgs ? args : null));
    }

    private Method getMethod(Class<?> type, String method, boolean noParamsOptional, Class<?> ... paramTypes) {
        boolean hasParams = paramTypes != null && paramTypes.length > 0;
        Method m = ReflectUtil.findMethod(type, (String)method, (Class[])paramTypes);
        if (m == null && noParamsOptional && hasParams) {
            this.useArgs = false;
            m = ReflectUtil.findMethod(type, (String)method, (Class[])null);
        }
        if (m == null) {
            throw new IllegalArgumentException("INIT: no dispatch method or wrong event handler class: " + method);
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            m.setAccessible(true);
        }
        return m;
    }
}

