/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.security;

import de.esoco.lib.logging.Log;
import de.esoco.lib.text.TextUtil;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class Security {
    public static final String ALIAS_SERVER_CERT = "_ServerCert";
    public static final String ALIAS_SIGNING_CERT = "_SigningCert";
    public static final String ALIAS_GENERATED_CERT = "_GeneratedCert";

    private Security() {
    }

    public static KeyStore createKeyStore(String alias, String password, PrivateKey privateKey, X509Certificate[] certChain) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), certChain);
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] decodeBase64(String base64) {
        base64 = base64.replaceAll("-----.*\n", "").replaceAll("\n", "").trim();
        return Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
    }

    public static X509Certificate decodeCertificate(byte[] certData) {
        try {
            ByteArrayInputStream data = new ByteArrayInputStream(certData);
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey decodePrivateKey(byte[] pkcs8Key) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8Key);
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decrypt(byte[] data, String passphrase) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            Key key = Security.deriveKey(passphrase, "AES", 128);
            cipher.init(2, key);
            return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Key deriveKey(String passphrase, String algorithm, int bitLength) {
        try {
            byte[] keyHash = Arrays.copyOf(MessageDigest.getInstance("SHA-256").digest(passphrase.getBytes(StandardCharsets.UTF_8)), bitLength / 8);
            return new SecretKeySpec(keyHash, algorithm);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void enableJavaCryptographicExtensions() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, Boolean.FALSE);
        }
        catch (Exception e) {
            Log.error("Unable to enable Java Cryptographic Extensions. Some ciphers may be unavailable in the current JRE.", e);
        }
    }

    public static String encodeBase64(byte[] data, String token) {
        String base64 = Base64.getEncoder().encodeToString(data);
        StringBuilder encoded = new StringBuilder("-----BEGIN ");
        int max = base64.length();
        token = token.toUpperCase();
        encoded.append(token).append("-----\n");
        for (int i = 0; i < max; i += 64) {
            int l = max - i;
            encoded.append(base64, i, i + (l > 64 ? 64 : l));
            encoded.append('\n');
        }
        encoded.append("-----END ").append(token).append("-----\n");
        return encoded.toString();
    }

    public static byte[] encrypt(String value, String passphrase) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            Key key = Security.deriveKey(passphrase, "AES", 128);
            cipher.init(1, key);
            return cipher.doFinal(value.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateHashId(String algorithm) {
        return Security.hash(algorithm, UUID.randomUUID().toString().getBytes());
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
            generator.initialize(keySize, random);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String generateSha256Id() {
        return Security.generateHashId("SHA-256");
    }

    public static SSLContext getSslContext(KeyStore keyStore, String keyStorePassword) {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String hash(String algorithm, byte[] data) {
        try {
            return TextUtil.hexString((byte[])MessageDigest.getInstance(algorithm).digest(data), (String)"");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unkown hash algorithm: " + algorithm, e);
        }
    }
}

