/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.service;

import de.esoco.lib.comm.HttpEndpoint;
import de.esoco.lib.comm.http.HttpRequestMethod;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.json.JsonBuilder;
import java.net.HttpURLConnection;
import java.util.LinkedHashMap;

public class ModificationSyncEndpoint
extends HttpEndpoint {
    public static SyncData forceSyncRequest(String client, String context, String targetId) {
        return new SyncData(client, context, targetId, true);
    }

    public static SyncRequest getCurrentLocks() {
        return new SyncRequest(HttpRequestMethod.GET, "current_locks");
    }

    public static SyncRequest releaseLock() {
        return new SyncRequest(HttpRequestMethod.POST, "release_lock");
    }

    public static SyncRequest requestLock() {
        return new SyncRequest(HttpRequestMethod.POST, "request_lock");
    }

    public static SyncData syncRequest(String client, String context, String targetId) {
        return new SyncData(client, context, targetId, false);
    }

    public static class SyncData {
        private final String client;
        private final String context;
        private final String targetId;
        private final boolean forceRequest;

        public SyncData(String client, String context, String targetId, boolean forceRequest) {
            this.client = client;
            this.context = context;
            this.targetId = targetId;
            this.forceRequest = forceRequest;
        }

        public String toJson() {
            LinkedHashMap<String, Object> requestData = new LinkedHashMap<String, Object>(3);
            requestData.put("client", this.client);
            requestData.put("context", this.context);
            requestData.put("target", this.targetId);
            if (this.forceRequest) {
                requestData.put("force", Boolean.TRUE);
            }
            return new JsonBuilder().appendObject(requestData).toString();
        }
    }

    public static class SyncRequest
    extends HttpEndpoint.HttpRequest<SyncData, String> {
        SyncRequest(HttpRequestMethod method, String requestUrl) {
            super(requestUrl, null, method, "/api/sync/" + requestUrl, data -> data != null ? data.toJson() : "", Functions.identity());
        }

        @Override
        protected String handleHttpError(HttpURLConnection urlConnection, Exception httpException, HttpStatusCode statusCode) {
            return statusCode.toString();
        }
    }
}

