/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.service;

import de.esoco.lib.app.RestService;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Server;
import de.esoco.lib.comm.http.HttpRequestHandler;
import de.esoco.lib.comm.http.HttpStatusCode;
import de.esoco.lib.comm.http.HttpStatusException;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.json.JsonObject;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.security.AuthenticationService;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.space.ObjectSpace;
import org.obrel.space.RelationSpace;
import org.obrel.type.StandardTypes;

public class ModificationSyncService
extends RestService
implements AuthenticationService {
    public static final String JSON_REQUEST_CLIENT = "client";
    public static final String JSON_REQUEST_CONTEXT = "context";
    public static final String JSON_REQUEST_TARGET_ID = "target";
    public static final String JSON_REQUEST_FORCE_FLAG = "force";
    public static final RelationType<ObjectSpace<Object>> SYNC = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static final RelationType<JsonObject> CHECK_LOCK = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static final RelationType<JsonObject> REQUEST_LOCK = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static final RelationType<JsonObject> RELEASE_LOCK = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private static final RelationType<Map<String, Map<String, LockData>>> CURRENT_LOCKS = RelationTypes.newType((RelationTypeModifier[])new RelationTypeModifier[0]);
    private final Map<String, Map<String, LockData>> contextLocks = new LinkedHashMap<String, Map<String, LockData>>();

    static String getClientAddress() {
        return ((InetAddress)HttpRequestHandler.getThreadLocalRequest().get(StandardTypes.IP_ADDRESS)).getHostAddress();
    }

    public static void main(String[] args) {
        new ModificationSyncService().run(args);
    }

    @Override
    public boolean authenticate(Relatable authData) {
        return true;
    }

    @Override
    protected ObjectSpace<Object> buildRestServerSpace() {
        ObjectSpace<Object> rootSpace = super.buildRestServerSpace();
        ObjectSpace apiSpace = (ObjectSpace)rootSpace.get(API);
        RelationSpace syncSpace = new RelationSpace(true);
        apiSpace.set(SYNC, (Object)syncSpace);
        ((ObjectSpace)apiSpace.get(STATUS)).set(CURRENT_LOCKS, this.contextLocks);
        syncSpace.set(StandardTypes.NAME, (Object)(this.getServiceName() + " Sync API"));
        syncSpace.init(CHECK_LOCK).onUpdate(this::checkLock);
        syncSpace.init(REQUEST_LOCK).onUpdate(this::requestLock);
        syncSpace.init(RELEASE_LOCK).onUpdate(this::releaseLock);
        syncSpace.set(CURRENT_LOCKS, this.contextLocks).onUpdate(this::updateLocks);
        return rootSpace;
    }

    @Override
    protected Server createRestServer() {
        Server restServer = super.createRestServer();
        restServer.set(CommunicationRelationTypes.MAX_CONNECTIONS, 20);
        return restServer;
    }

    private void checkLock(JsonObject request) {
        this.processSyncRequest(request, this::handleCheckLock);
    }

    private void handleCheckLock(String clientId, String context, String targetId, boolean forceRequest) {
        boolean hasLock = this.contextLocks.containsKey(context) && this.contextLocks.get(context).containsKey(targetId);
        throw new HttpStatusException(HttpStatusCode.OK, Boolean.toString(hasLock), new Pair[0]);
    }

    private void handleReleaseLock(String client, String context, String targetId, boolean forceRequest) {
        Map<String, LockData> locks = this.contextLocks.get(context);
        LockData currentLock = null;
        if (locks != null) {
            currentLock = locks.get(targetId);
        } else {
            this.respond(HttpStatusCode.NOT_FOUND, "Unknown context " + context);
        }
        if (currentLock != null) {
            boolean lockedByClient = currentLock.isHeldBy(client);
            if (lockedByClient || forceRequest) {
                if (forceRequest && !lockedByClient) {
                    Log.warnf("Locked by %s, release forced by %s", currentLock.getClientInfo(), client);
                }
                locks.remove(targetId);
                if (Log.isLevelEnabled(LogLevel.DEBUG)) {
                    Log.debugf("Current locks: %s", this.contextLocks);
                }
            } else {
                this.respond(HttpStatusCode.CONFLICT, client);
            }
        } else {
            this.respond(HttpStatusCode.NOT_FOUND, context + ":" + targetId);
        }
    }

    private void handleRequestLock(String client, String context, String targetId, boolean forceRequest) {
        LockData currentLock;
        Map<String, LockData> locks = this.contextLocks.get(context);
        if (locks == null) {
            locks = new LinkedHashMap<String, LockData>();
            this.contextLocks.put(context, locks);
        }
        if ((currentLock = locks.get(targetId)) == null || forceRequest) {
            LockData newLock = new LockData(client);
            if (forceRequest && currentLock != null) {
                Log.warnf("Locked by %s, forcing lock to %s", currentLock.getClientInfo(), newLock);
            }
            locks.put(targetId, newLock);
            Log.debug("Current locks: " + this.contextLocks);
        } else if (currentLock.isHeldBy(client)) {
            this.respond(HttpStatusCode.ALREADY_REPORTED, "");
        } else {
            this.respond(HttpStatusCode.LOCKED, client);
        }
    }

    private void processSyncRequest(JsonObject request, SyncRequestHandler requestHandler) {
        try {
            Option clientId = request.getProperty(JSON_REQUEST_CLIENT);
            Option context = request.getProperty(JSON_REQUEST_CONTEXT);
            Option globalId = request.getProperty(JSON_REQUEST_TARGET_ID);
            Option force = request.getProperty(JSON_REQUEST_FORCE_FLAG);
            if (!(clientId.is(String.class) && context.is(String.class) && globalId.is(String.class) && force.is(Boolean.class))) {
                this.respond(HttpStatusCode.BAD_REQUEST, request.toString());
            }
            requestHandler.handleRequest((String)clientId.map(Object::toString).orFail(), (String)context.map(Object::toString).orFail(), (String)globalId.map(Object::toString).orFail(), (Boolean)force.map(Boolean.class::cast).orFail());
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            this.respond(HttpStatusCode.BAD_REQUEST, request.toString());
        }
    }

    private void releaseLock(JsonObject request) {
        this.processSyncRequest(request, this::handleReleaseLock);
    }

    private void requestLock(JsonObject request) {
        this.processSyncRequest(request, this::handleRequestLock);
    }

    private void respond(HttpStatusCode status, String message) {
        throw new HttpStatusException(status, message, new Pair[0]);
    }

    private void updateLocks(Map<?, ?> newLocks) {
        this.respond(HttpStatusCode.METHOD_NOT_ALLOWED, "Setting all locks is not supported");
    }

    static {
        RelationTypes.init((Class[])new Class[]{ModificationSyncService.class});
    }

    @FunctionalInterface
    private static interface SyncRequestHandler {
        public void handleRequest(String var1, String var2, String var3, boolean var4);
    }

    private static class LockData {
        Date lockTime = new Date();
        String clientId;
        String clientAddress;

        LockData(String clientId) {
            this.clientId = clientId;
            this.clientAddress = ModificationSyncService.getClientAddress();
        }

        public String getClientInfo() {
            return String.format("%s[%s]", this.clientId, this.clientAddress);
        }

        public boolean isHeldBy(String client) {
            return this.clientId.equals(client);
        }

        public String toString() {
            return String.format("%s[%s] (%3$tF %3$tT.%3$tL)", this.clientId, this.clientAddress, this.lockTime);
        }
    }
}

