/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.service;

import de.esoco.lib.app.Application;
import de.esoco.lib.app.CommandLine;
import de.esoco.lib.app.Service;
import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.comm.CommunicationRelationTypes;
import de.esoco.lib.comm.Endpoint;
import de.esoco.lib.comm.EndpointFunction;
import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonObject;
import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogExtent;
import de.esoco.lib.logging.LogLevel;
import de.esoco.lib.security.Security;
import de.esoco.lib.service.ModificationSyncEndpoint;
import java.util.LinkedHashMap;
import java.util.Map;

public class ModificationSyncServiceTool
extends Application {
    private Endpoint syncService;
    private EndpointFunction<ModificationSyncEndpoint.SyncData, String> releaseLock;
    private EndpointFunction<ModificationSyncEndpoint.SyncData, String> requestLock;
    private Map<String, String> commandLineOptions = null;

    public static void main(String[] args) {
        try {
            new ModificationSyncServiceTool().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getAppDescription() {
        return "Sends a command to a ModificationSyncService running at an URL that must be set with -url. Use -h or --help for help.";
    }

    @Override
    protected Map<String, String> getCommandLineOptions() {
        if (this.commandLineOptions == null) {
            this.commandLineOptions = new LinkedHashMap<String, String>();
            String helpInfo = "Display this help or informations about a certain command";
            this.commandLineOptions.put("h", helpInfo);
            this.commandLineOptions.put("-help", helpInfo);
            this.commandLineOptions.put("url", "The URL of the sync service (mandatory)");
            this.commandLineOptions.put("context", "The context to which to apply a command");
            this.commandLineOptions.put("target", "The target to which to apply a command (in a certain context)");
            for (Command command : Command.values()) {
                this.commandLineOptions.put(command.name().toLowerCase(), command.getHelpText());
            }
        }
        return this.commandLineOptions;
    }

    protected void handleCommands(CommandLine commandLine, String context, String target) {
        block5: for (Command command : Command.values()) {
            String cmd = command.name().toLowerCase();
            if (!commandLine.hasOption(cmd)) continue;
            System.out.printf("Applying %s to %s\n", new Object[]{command, this.syncService.get(CommunicationRelationTypes.ENDPOINT_ADDRESS)});
            switch (command.ordinal()) {
                case 0: 
                case 3: {
                    this.handleListAndReset(command, context);
                    continue block5;
                }
                case 4: {
                    this.handleGetAndSetLogLevel(commandLine.getString(cmd));
                    continue block5;
                }
                case 1: 
                case 2: {
                    this.handleLockAndUnlock(command, context, target);
                    continue block5;
                }
                default: {
                    assert (false) : "Unhandled command " + (Object)((Object)command);
                    continue block5;
                }
            }
        }
    }

    @Override
    protected void runApp() throws Exception {
        CommandLine commandLine = this.getCommandLine();
        this.syncService = Endpoint.at(commandLine.requireString("url"));
        this.requestLock = ModificationSyncEndpoint.requestLock().from(this.syncService);
        this.releaseLock = ModificationSyncEndpoint.releaseLock().from(this.syncService);
        this.syncService.set(Log.LOG_EXTENT, (Object)LogExtent.NOTHING);
        String context = commandLine.getString("context");
        String target = commandLine.getString("target");
        this.handleCommands(commandLine, context, target);
    }

    private String getClientId() {
        return ((Object)((Object)this)).getClass().getSimpleName() + Security.generateSha256Id().substring(0, 8);
    }

    private JsonObject getLocks() {
        return Json.parseObject((String)((String)ModificationSyncEndpoint.getCurrentLocks().from(this.syncService).receive()));
    }

    private void handleGetAndSetLogLevel(String newLevel) {
        if (newLevel != null && LogLevel.valueOf(newLevel) != null) {
            Service.SET_LOG_LEVEL.on(this.syncService).send(Json.toJson((Object)newLevel));
        } else {
            System.out.printf("Current log level: %s\n", Service.GET_LOG_LEVEL.from(this.syncService).receive());
        }
    }

    private void handleListAndReset(Command command, String context) {
        JsonObject locks = this.getLocks();
        if (locks.isEmpty()) {
            System.out.print("No lock contexts defined\n");
        } else if (context != null) {
            if (command == Command.RESET) {
                this.unlockAll(context, (Option<JsonObject>)locks.getObject(context));
            } else {
                this.printLocks(context, (Option<JsonObject>)locks.getObject(context));
            }
        } else if (command == Command.RESET) {
            for (String ctx : locks.getProperties().keySet()) {
                this.unlockAll(ctx, (Option<JsonObject>)locks.getObject(ctx));
            }
        } else {
            for (String ctx : locks.getPropertyNames()) {
                this.printLocks(ctx, (Option<JsonObject>)locks.getObject(ctx));
            }
        }
    }

    private void handleLockAndUnlock(Command command, String context, String target) {
        if (context == null) {
            System.out.print("Sync context must be provided (-context <context>)\n");
        } else if (target == null) {
            System.out.print("Sync target must be provided (-target <target>)\n");
        } else {
            ModificationSyncEndpoint.SyncData syncData = new ModificationSyncEndpoint.SyncData(this.getClientId(), context, target, true);
            if (command == Command.LOCK) {
                this.requestLock.send(syncData);
            } else {
                this.releaseLock.send(syncData);
            }
        }
    }

    private void printLocks(String context, Option<JsonObject> contextLocks) {
        contextLocks.ifExists(locks -> {
            if (locks.isEmpty()) {
                System.out.printf("No locks in existing context %s\n", context);
            } else {
                System.out.printf("Locks for context %s:\n  %s\n", context, CollectionUtil.toString((Map)locks.getProperties(), (String)": ", (String)"\n  "));
            }
        });
    }

    private void unlockAll(String context, Option<JsonObject> contextLocks) {
        String clientId = this.getClientId();
        contextLocks.ifExists(locks -> {
            for (String target : locks.getProperties().keySet()) {
                this.releaseLock.send(new ModificationSyncEndpoint.SyncData(clientId, context, target, true));
                System.out.printf("Removed lock on %s from context %s (acquired by %s)\n", target, context, locks.getString(target).orUse((Object)"unknown"));
            }
        });
    }

    static enum Command {
        LIST("Lists either all locks or only in a given context"),
        LOCK("Locks a target in a context"),
        UNLOCK("Removes a target lock in a context"),
        RESET("Resets either all locks or only in the given context"),
        LOGLEVEL("Queries or updates the log level of the target service");

        private final String helpText;

        private Command(String help) {
            this.helpText = help;
        }

        public final String getHelpText() {
            return this.helpText;
        }
    }
}

