/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage;

import de.esoco.storage.Query;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.QueryResult;
import de.esoco.storage.Storage;
import de.esoco.storage.StorageDefinition;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageRuntimeException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class QueryList<T>
extends AbstractList<T> {
    private final StorageDefinition storageDefinition;
    private final QueryPredicate<T> queryPredicate;
    private int size = -1;
    private ElementInitializer<T> initializer = null;
    private ArrayList<T> elements = null;
    private boolean queried = false;

    public QueryList() {
        this.storageDefinition = null;
        this.queryPredicate = null;
        this.elements = new ArrayList();
        this.queried = true;
    }

    public QueryList(StorageDefinition definition, QueryPredicate<T> childQuery, int size, ElementInitializer<T> initializer) {
        this.storageDefinition = definition;
        this.queryPredicate = childQuery;
        this.size = size;
        this.initializer = initializer;
    }

    @Override
    public void add(int index, T element) {
        this.query();
        this.elements.add(index, element);
    }

    @Override
    public T get(int index) {
        this.query();
        return this.elements.get(index);
    }

    public final QueryPredicate<T> getQueryPredicate() {
        return this.queryPredicate;
    }

    public final boolean isQueried() {
        return this.queried;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void query() throws StorageRuntimeException {
        if (!this.queried) {
            Storage storage = null;
            try {
                storage = StorageManager.getStorage((Object)this.storageDefinition);
                try (Query<T> query = storage.query(this.queryPredicate);){
                    QueryResult<T> result = query.execute();
                    ArrayList<T> resultObjects = new ArrayList<T>();
                    while (result.hasNext()) {
                        resultObjects.add(result.next());
                    }
                    if (this.initializer != null) {
                        this.initializer.initElements(resultObjects);
                    }
                    this.elements = resultObjects;
                    this.size = this.elements.size();
                    this.queried = true;
                }
            }
            catch (StorageException e) {
                throw new StorageRuntimeException(e);
            }
            finally {
                if (storage != null) {
                    storage.release();
                }
            }
        }
    }

    @Override
    public T remove(int index) {
        this.query();
        return this.elements.remove(index);
    }

    @Override
    public T set(int index, T element) {
        this.query();
        return this.elements.set(index, element);
    }

    @Override
    public int size() {
        if (this.size < 0) {
            this.query();
        }
        return this.elements != null ? this.elements.size() : this.size;
    }

    public static interface ElementInitializer<T> {
        public void initElements(List<T> var1);
    }
}

