/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage;

import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.Releasable;
import de.esoco.lib.manage.Transactional;
import de.esoco.storage.AfterStoreHandler;
import de.esoco.storage.Query;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import java.util.Collection;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.type.MetaTypes;

public abstract class Storage
extends RelatedObject
implements Transactional,
Releasable {
    public static final String PROPERTY_DELETE_DISABLED = "esoco.storage.disable_delete";
    int usageCount = 1;

    public abstract void commit() throws StorageException;

    public final void delete(Object object) throws StorageException {
        this.checkStorageDeleteEnabled(StorageManager.getMapping(object.getClass()));
        this.deleteObject(object);
    }

    public abstract String getStorageImplementationName();

    public final boolean hasObjectStorage(Class<?> storedType) throws StorageException {
        return this.hasObjectStorage(StorageManager.getMapping(storedType));
    }

    public final void initObjectStorage(Class<?> storedType) throws StorageException {
        this.initObjectStorage(StorageManager.getMapping(storedType));
    }

    public abstract boolean isValid();

    public abstract <T> Query<T> query(QueryPredicate<T> var1) throws StorageException;

    public void release() {
        StorageManager.releaseStorage(this);
    }

    public void removeObjectStorage(Class<?> storedType) throws StorageException {
        StorageMapping<?, ?, ?> mapping = StorageManager.getMapping(storedType);
        this.checkStorageDeleteEnabled(mapping);
        this.removeObjectStorage(mapping);
    }

    public abstract void rollback() throws StorageException;

    public final void store(Object object) throws StorageException {
        if (object instanceof Collection) {
            this.storeCollection((Collection)object);
        } else {
            this.storeSingleObject(object);
        }
    }

    protected void checkStorageDeleteEnabled(StorageMapping<?, ?, ?> mapping) throws StorageException {
        if (!mapping.isDeleteAllowed()) {
            throw new StorageException(String.format("Delete not enabled for ", mapping.getMappedType()));
        }
        if (Boolean.getBoolean(PROPERTY_DELETE_DISABLED)) {
            throw new StorageException("Delete globally disabled");
        }
    }

    protected abstract void close();

    protected abstract void deleteObject(Object var1) throws StorageException;

    protected abstract boolean hasObjectStorage(StorageMapping<?, ?, ?> var1) throws StorageException;

    protected abstract void initObjectStorage(StorageMapping<?, ?, ?> var1) throws StorageException;

    protected abstract void removeObjectStorage(StorageMapping<?, ?, ?> var1) throws StorageException;

    protected void storeCollection(Collection<?> objects) throws StorageException {
        for (Object element : objects) {
            this.storeSingleObject(element);
        }
    }

    protected abstract void storeObject(Object var1) throws Exception;

    private void storeSingleObject(Object object) throws StorageException {
        Relatable objectRelatable = ObjectRelations.getRelatable((Object)object);
        objectRelatable.set(StorageRelationTypes.STORING);
        try {
            this.storeObject(object);
            if (!objectRelatable.hasRelation(StorageRelationTypes.PERSISTENT)) {
                objectRelatable.set(StorageRelationTypes.PERSISTENT);
            }
            if (objectRelatable.hasRelation(MetaTypes.MODIFIED)) {
                objectRelatable.set(MetaTypes.MODIFIED, (Object)Boolean.FALSE);
            }
            if (object instanceof AfterStoreHandler) {
                ((AfterStoreHandler)object).afterStore();
            }
        }
        catch (Exception e) {
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            String message = "Store failed: " + object;
            Log.error((String)message, (Throwable)e);
            throw new StorageException(message, e);
        }
        finally {
            objectRelatable.deleteRelation(StorageRelationTypes.STORING);
        }
    }
}

