/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage;

import de.esoco.lib.logging.Log;
import de.esoco.lib.logging.LogRecord;
import de.esoco.storage.Storage;
import de.esoco.storage.StorageDefinition;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.mapping.ClassMapping;
import de.esoco.storage.mapping.FieldDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class StorageManager {
    private static final Object DEFAULT_STORAGE = "DEFAULT_STORAGE";
    private static final boolean DEBUG_OUTPUT = false;
    private static final Map<Class<?>, MappingFactory<?>> mappingFactoryRegistry = new LinkedHashMap();
    private static final Map<Object, StorageDefinition> storageDefinitionRegistry = new HashMap<Object, StorageDefinition>();
    private static ThreadLocal<Map<StorageDefinition, Storage>> threadStorages;
    private static final RelatedObject storageMetaData;

    private StorageManager() {
    }

    static StorageDefinition checkStorageDefinition(Object key) throws StorageException {
        StorageDefinition definition = StorageManager.getStorageDefinition(key);
        if (definition == null) {
            throw new StorageException("No storage definition for key " + key);
        }
        return definition;
    }

    public static String convertToSqlConstraint(String constraint) {
        constraint = constraint.replaceAll("\\*", "%");
        constraint = constraint.replaceAll("\\?", "_");
        return constraint;
    }

    static Storage createStorage(StorageDefinition definition) throws StorageException {
        Storage storage = definition.createStorage();
        ObjectRelations.copyRelations((Relatable)storageMetaData, (Relatable)storage, (boolean)false);
        storage.set(StorageRelationTypes.STORAGE_DEFINITION, (Object)definition);
        if (definition.hasRelation(StorageRelationTypes.QUERY_DEPTH)) {
            storage.set(StorageRelationTypes.QUERY_DEPTH, (Integer)definition.get(StorageRelationTypes.QUERY_DEPTH));
        }
        return storage;
    }

    private static void debugOutStorageAccess(String info, Storage storage) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int stackOverhead = LogRecord.getStackOverhead((Package)StorageManager.class.getPackage(), (StackTraceElement[])stackTrace);
        StackTraceElement location = stackTrace[stackOverhead];
        Log.infof((String)"%s STORAGE %s[Usage %d] from %s.%s[%d]\n", (Object[])new Object[]{info, storage.get(StandardTypes.OBJECT_ID), storage.usageCount, location.getClassName(), location.getMethodName(), location.getLineNumber()});
    }

    public static <T> StorageMapping<T, ?, ?> getMapping(Class<T> type) {
        StorageMapping<Object, FieldDescriptor, ClassMapping<?>> mapping = (ClassMapping<T>)ObjectRelations.getRelatable(type).get(StorageRelationTypes.STORAGE_MAPPING);
        if (mapping == null) {
            for (Map.Entry<Class<?>, MappingFactory<?>> entry : mappingFactoryRegistry.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                mapping = entry.getValue().createMapping(type);
                break;
            }
            if (mapping == null) {
                mapping = new ClassMapping<T>(type);
            }
        }
        return mapping;
    }

    public static <T> MappingFactory<T> getMappingFactory(Class<T> baseClass) {
        return mappingFactoryRegistry.get(baseClass);
    }

    public static Storage getStorage(Object key) throws StorageException {
        StorageDefinition definition;
        Map<StorageDefinition, Storage> storageMap = threadStorages.get();
        Storage storage = storageMap.get((Object)(definition = StorageManager.checkStorageDefinition(key)));
        if (storage == null || !storage.isValid()) {
            storage = StorageManager.createStorage(definition);
            storageMap.put(definition, storage);
            storage.set(MetaTypes.MANAGED);
        } else {
            ++storage.usageCount;
        }
        return storage;
    }

    public static StorageDefinition getStorageDefinition(Object key) {
        StorageDefinition definition = key instanceof StorageDefinition ? (StorageDefinition)((Object)key) : (storageDefinitionRegistry.containsKey(key) ? storageDefinitionRegistry.get(key) : storageDefinitionRegistry.get(DEFAULT_STORAGE));
        return definition;
    }

    public static boolean isPersistent(Object object) {
        Relatable objectRelatable = ObjectRelations.getRelatable((Object)object);
        return objectRelatable.hasFlag(StorageRelationTypes.PERSISTENT) || objectRelatable.hasFlag(StorageRelationTypes.STORING);
    }

    public static Storage newStorage(Object key) throws StorageException {
        StorageDefinition definition = StorageManager.checkStorageDefinition(key);
        Storage storage = StorageManager.createStorage(definition);
        storage.set(MetaTypes.MANAGED, false);
        return storage;
    }

    public static <T> void registerMappingFactory(Class<T> baseClass, MappingFactory<T> factory) {
        mappingFactoryRegistry.put(baseClass, factory);
    }

    public static void registerStorage(StorageDefinition definition, Object ... keys) {
        if (definition == null || keys == null || keys.length == 0) {
            throw new IllegalArgumentException("Arguments must not be NULL or empty");
        }
        for (Object key : keys) {
            storageDefinitionRegistry.put(key, definition);
        }
    }

    static void releaseStorage(Storage storage) {
        if (--storage.usageCount == 0) {
            if (storage.hasFlag(MetaTypes.MANAGED)) {
                threadStorages.get().remove(storage.get(StorageRelationTypes.STORAGE_DEFINITION));
            }
            storage.close();
        }
    }

    public static void setDefaultStorage(StorageDefinition definition) {
        StorageManager.registerStorage(definition, DEFAULT_STORAGE);
    }

    public static <T> void setStorageMetaData(RelationType<T> type, T value) {
        storageMetaData.set(type, value);
    }

    public static void shutdown() {
        Map<StorageDefinition, Storage> storageMap = threadStorages.get();
        if (storageMap != null) {
            storageMap.values().forEach(Storage::release);
        }
        threadStorages = null;
    }

    static {
        storageMetaData = new RelatedObject();
        StorageRelationTypes.init();
        threadStorages = new ThreadLocal<Map<StorageDefinition, Storage>>(){

            @Override
            protected Map<StorageDefinition, Storage> initialValue() {
                return new HashMap<StorageDefinition, Storage>();
            }
        };
    }

    public static interface MappingFactory<T> {
        public StorageMapping<T, ?, ?> createMapping(Class<T> var1);
    }
}

