/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.ElementAccessFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import de.esoco.lib.expression.function.GetElement;
import de.esoco.lib.expression.predicate.Comparison;
import de.esoco.lib.expression.predicate.ElementPredicate;
import de.esoco.lib.property.SortDirection;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.impl.jdbc.JdbcStorage;
import de.esoco.storage.impl.jdbc.SqlExpressionFormat;
import java.util.regex.Pattern;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public class StoragePredicates {
    private StoragePredicates() {
    }

    public static <T> Predicate<T> createWildcardFilter(String filter) {
        if (filter.indexOf(42) == -1) {
            filter = "%" + filter + "%";
        }
        filter = StorageManager.convertToSqlConstraint(filter);
        return StoragePredicates.like(filter);
    }

    public static <T> QueryPredicate<T> forType(Class<T> type, Predicate<? super T> critera) {
        return new QueryPredicate<T>(type, critera);
    }

    public static <T> Predicate<T> hasChild(Class<T> childType, Predicate<? super T> childCritera) {
        return new QueryPredicate<T>(childType, childCritera);
    }

    public static <T, A extends Relatable> ElementPredicate<T, Object> ifAttribute(StorageMapping<T, A, ?> mapping, A attribute, Predicate<Object> valueCriteria) {
        return new ElementPredicate(new GetAttribute<T, A>(mapping, attribute), valueCriteria);
    }

    public static <T, V> ElementPredicate<T, V> ifField(String field, Predicate<V> valueCriteria) {
        return Predicates.ifField((String)field, valueCriteria);
    }

    public static BinaryPredicate<Object, String> like(String sqlPattern) {
        return new Like(sqlPattern, false);
    }

    public static <T> QueryPredicate<T> refersTo(Class<T> referencedType, Predicate<? super T> critera) {
        return new QueryPredicate<T>(referencedType, critera);
    }

    public static <T, V> Predicate<V> refersTo(Class<T> referencedType, Function<? super T, V> referencedAttr, Predicate<? super T> critera) {
        QueryPredicate<? super T> refersTo = StoragePredicates.refersTo(referencedType, critera);
        refersTo.set(StorageRelationTypes.STORAGE_FUNCTION, referencedAttr);
        return refersTo;
    }

    public static BinaryPredicate<Object, String> similarTo(String value) {
        return new Like(value, true);
    }

    public static <T> SortPredicate<T> sortBy(String field) {
        return StoragePredicates.sortBy(field, true);
    }

    public static <T extends Relatable> SortPredicate<T> sortBy(RelationType<?> type) {
        return StoragePredicates.sortBy(type, true);
    }

    public static <T> SortPredicate<T> sortBy(String field, boolean ascending) {
        return StoragePredicates.sortBy(field, ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING);
    }

    public static <T> SortPredicate<T> sortBy(String field, SortDirection direction) {
        return new SortPredicate(field, direction);
    }

    public static <T extends Relatable> SortPredicate<T> sortBy(RelationType<?> type, boolean ascending) {
        return StoragePredicates.sortBy(type, ascending ? SortDirection.ASCENDING : SortDirection.DESCENDING);
    }

    public static <T extends Relatable> SortPredicate<T> sortBy(RelationType<?> type, SortDirection direction) {
        return new SortPredicate(type, direction);
    }

    public static class GetAttribute<I, A extends Relatable>
    extends GetElement<I, A, Object> {
        private final StorageMapping<I, A, ?> storageMapping;

        public GetAttribute(StorageMapping<I, A, ?> mapping, A attribute) {
            super(attribute, "GetAttribute");
            this.storageMapping = mapping;
        }

        protected Object getElementValue(I object, A attribute) {
            try {
                return this.storageMapping.getAttributeValue(object, attribute);
            }
            catch (StorageException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class Like
    extends Comparison<Object, String>
    implements SqlExpressionFormat {
        private boolean fuzzySearch;

        public Like(String sqlPattern, boolean fuzzySearch) {
            super((Object)sqlPattern, "LIKE");
            this.fuzzySearch = fuzzySearch;
        }

        public static String convertLikeToRegEx(String sqlPattern) {
            sqlPattern = sqlPattern.replaceAll("%", ".*");
            sqlPattern = sqlPattern.replaceAll("_", ".");
            return sqlPattern;
        }

        public Boolean evaluate(Object value, String pattern) {
            return Pattern.matches(Like.convertLikeToRegEx(pattern), value.toString());
        }

        @Override
        public String format(JdbcStorage storage, Predicate<?> expression, String column, String value, boolean negate) {
            StringBuilder result = new StringBuilder();
            String fuzzySearchFunction = storage.getFuzzySearchFunction();
            if (this.fuzzySearch && fuzzySearchFunction != null) {
                result.append(fuzzySearchFunction);
                result.append('(').append(column).append(')').append(' ');
                result.append(negate ? "<>" : "=");
                result.append(' ').append(fuzzySearchFunction);
                result.append('(').append(value).append(')');
            } else {
                result.append(column).append(' ');
                result.append(negate ? "NOT LIKE" : "LIKE");
                result.append(' ').append(value);
            }
            return result.toString();
        }
    }

    public static class SortPredicate<T>
    extends ElementPredicate<T, Object> {
        public SortPredicate(String field, SortDirection direction) {
            this((ElementAccessFunction<?, T, ?>)new GetElement.ReadField(field), direction);
        }

        public SortPredicate(ElementAccessFunction<?, ? super T, ?> sortElement, SortDirection direction) {
            super(sortElement, Predicates.alwaysTrue());
            this.set(MetaTypes.SORT_DIRECTION, direction);
        }
    }
}

